/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTestCallback.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMBinding.h"
#include "WebKitDOMClass1Private.h"
#include "WebKitDOMClass2Private.h"
#include "WebKitDOMClass3Private.h"
#include "WebKitDOMClass8Private.h"
#include "WebKitDOMDOMStringListPrivate.h"
#include "WebKitDOMTestCallbackPrivate.h"
#include "WebKitDOMThisClassPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include "webkitglobalsprivate.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(SQL_DATABASE)

namespace WebKit {

WebKitDOMTestCallback* kit(WebCore::TestCallback* obj)
{
    g_return_val_if_fail(obj, 0);

    if (gpointer ret = DOMObjectCache::get(obj))
        return static_cast<WebKitDOMTestCallback*>(ret);

    return static_cast<WebKitDOMTestCallback*>(DOMObjectCache::put(obj, WebKit::wrapTestCallback(obj)));
}

WebCore::TestCallback* core(WebKitDOMTestCallback* request)
{
    g_return_val_if_fail(request, 0);

    WebCore::TestCallback* coreObject = static_cast<WebCore::TestCallback*>(WEBKIT_DOM_OBJECT(request)->coreObject);
    g_return_val_if_fail(coreObject, 0);

    return coreObject;
}

WebKitDOMTestCallback* wrapTestCallback(WebCore::TestCallback* coreObject)
{
    g_return_val_if_fail(coreObject, 0);

    // We call ref() rather than using a C++ smart pointer because we can't store a C++ object
    // in a C-allocated GObject structure. See the finalize() code for the matching deref().
    coreObject->ref();

    return WEBKIT_DOM_TEST_CALLBACK(g_object_new(WEBKIT_TYPE_DOM_TEST_CALLBACK, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(SQL_DATABASE)

G_DEFINE_TYPE(WebKitDOMTestCallback, webkit_dom_test_callback, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
};

static void webkit_dom_test_callback_finalize(GObject* object)
{
#if ENABLE(SQL_DATABASE)
    WebKitDOMObject* domObject = WEBKIT_DOM_OBJECT(object);
    
    if (domObject->coreObject) {
        WebCore::TestCallback* coreObject = static_cast<WebCore::TestCallback*>(domObject->coreObject);

        WebKit::DOMObjectCache::forget(coreObject);
        coreObject->deref();

        domObject->coreObject = 0;
    }
#endif // ENABLE(SQL_DATABASE)

    G_OBJECT_CLASS(webkit_dom_test_callback_parent_class)->finalize(object);
}

static void webkit_dom_test_callback_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (propertyId) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}


static void webkit_dom_test_callback_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (propertyId) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}


static void webkit_dom_test_callback_constructed(GObject* object)
{

    if (G_OBJECT_CLASS(webkit_dom_test_callback_parent_class)->constructed)
        G_OBJECT_CLASS(webkit_dom_test_callback_parent_class)->constructed(object);
}

static void webkit_dom_test_callback_class_init(WebKitDOMTestCallbackClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->finalize = webkit_dom_test_callback_finalize;
    gobjectClass->set_property = webkit_dom_test_callback_set_property;
    gobjectClass->get_property = webkit_dom_test_callback_get_property;
    gobjectClass->constructed = webkit_dom_test_callback_constructed;



}

static void webkit_dom_test_callback_init(WebKitDOMTestCallback* request)
{
}

gboolean
webkit_dom_test_callback_callback_with_no_param(WebKitDOMTestCallback* self)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    gboolean result = item->callbackWithNoParam();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

gboolean
webkit_dom_test_callback_callback_with_class1param(WebKitDOMTestCallback* self, WebKitDOMClass1* class1Param)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    g_return_val_if_fail(class1Param, 0);
    WebCore::Class1* convertedClass1Param = 0;
    if (class1Param) {
        convertedClass1Param = WebKit::core(class1Param);
        g_return_val_if_fail(convertedClass1Param, 0);
    }
    gboolean result = item->callbackWithClass1Param(convertedClass1Param);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

gboolean
webkit_dom_test_callback_callback_with_class2param(WebKitDOMTestCallback* self, WebKitDOMClass2* class2Param, const gchar* strArg)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    g_return_val_if_fail(class2Param, 0);
    g_return_val_if_fail(strArg, 0);
    WebCore::Class2* convertedClass2Param = 0;
    if (class2Param) {
        convertedClass2Param = WebKit::core(class2Param);
        g_return_val_if_fail(convertedClass2Param, 0);
    }
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    gboolean result = item->callbackWithClass2Param(convertedClass2Param, convertedStrArg);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

glong
webkit_dom_test_callback_callback_with_non_bool_return_type(WebKitDOMTestCallback* self, WebKitDOMClass3* class3Param)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    g_return_val_if_fail(class3Param, 0);
    WebCore::Class3* convertedClass3Param = 0;
    if (class3Param) {
        convertedClass3Param = WebKit::core(class3Param);
        g_return_val_if_fail(convertedClass3Param, 0);
    }
    glong result = item->callbackWithNonBoolReturnType(convertedClass3Param);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<glong>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

gboolean
webkit_dom_test_callback_callback_with_string_list(WebKitDOMTestCallback* self, WebKitDOMDOMStringList* listParam)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    g_return_val_if_fail(listParam, 0);
    WebCore::DOMStringList* convertedListParam = 0;
    if (listParam) {
        convertedListParam = WebKit::core(listParam);
        g_return_val_if_fail(convertedListParam, 0);
    }
    gboolean result = item->callbackWithStringList(convertedListParam);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

gboolean
webkit_dom_test_callback_callback_with_boolean(WebKitDOMTestCallback* self, gboolean boolParam)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    gboolean result = item->callbackWithBoolean(boolParam);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

gboolean
webkit_dom_test_callback_callback_requires_this_to_pass(WebKitDOMTestCallback* self, WebKitDOMClass8* class8Param, WebKitDOMThisClass* thisClassParam)
{
#if ENABLE(SQL_DATABASE)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCallback* item = WebKit::core(self);
    g_return_val_if_fail(class8Param, 0);
    g_return_val_if_fail(thisClassParam, 0);
    WebCore::Class8* convertedClass8Param = 0;
    if (class8Param) {
        convertedClass8Param = WebKit::core(class8Param);
        g_return_val_if_fail(convertedClass8Param, 0);
    }
    WebCore::ThisClass* convertedThisClassParam = 0;
    if (thisClassParam) {
        convertedThisClassParam = WebKit::core(thisClassParam);
        g_return_val_if_fail(convertedThisClassParam, 0);
    }
    gboolean result = item->callbackRequiresThisToPass(convertedClass8Param, convertedThisClassParam);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SQL_DATABASE) */
}

