/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSConsole.h"

#include "Console.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSMemoryInfo.h"
#include "JSScriptProfile.h"
#include "MemoryInfo.h"
#include "ScriptArguments.h"
#include "ScriptCallStackFactory.h"
#include "ScriptProfile.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSConsoleTableValues[] =
{
    { "profiles", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConsoleProfiles), (intptr_t)0, NoIntrinsic },
    { "memory", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConsoleMemory), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSConsoleTable = { 4, 3, JSConsoleTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSConsolePrototypeTableValues[] =
{
    { "debug", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionDebug), (intptr_t)0, NoIntrinsic },
    { "error", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionError), (intptr_t)0, NoIntrinsic },
    { "info", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionInfo), (intptr_t)0, NoIntrinsic },
    { "log", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionLog), (intptr_t)0, NoIntrinsic },
    { "warn", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionWarn), (intptr_t)0, NoIntrinsic },
    { "dir", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionDir), (intptr_t)0, NoIntrinsic },
    { "dirxml", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionDirxml), (intptr_t)0, NoIntrinsic },
    { "trace", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionTrace), (intptr_t)0, NoIntrinsic },
    { "assert", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionAssert), (intptr_t)1, NoIntrinsic },
    { "count", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionCount), (intptr_t)0, NoIntrinsic },
    { "markTimeline", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionMarkTimeline), (intptr_t)0, NoIntrinsic },
    { "profile", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionProfile), (intptr_t)1, NoIntrinsic },
    { "profileEnd", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionProfileEnd), (intptr_t)1, NoIntrinsic },
    { "time", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionTime), (intptr_t)1, NoIntrinsic },
    { "timeEnd", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionTimeEnd), (intptr_t)1, NoIntrinsic },
    { "timeStamp", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionTimeStamp), (intptr_t)0, NoIntrinsic },
    { "group", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionGroup), (intptr_t)0, NoIntrinsic },
    { "groupCollapsed", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionGroupCollapsed), (intptr_t)0, NoIntrinsic },
    { "groupEnd", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionGroupEnd), (intptr_t)0, NoIntrinsic },
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsConsolePrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSConsolePrototypeTable = { 65, 63, JSConsolePrototypeTableValues, 0 };
const ClassInfo JSConsolePrototype::s_info = { "ConsolePrototype", &Base::s_info, &JSConsolePrototypeTable, 0, CREATE_METHOD_TABLE(JSConsolePrototype) };

JSObject* JSConsolePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSConsole>(exec, globalObject);
}

bool JSConsolePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSConsolePrototype* thisObject = jsCast<JSConsolePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSConsolePrototypeTable, thisObject, propertyName, slot);
}

bool JSConsolePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSConsolePrototype* thisObject = jsCast<JSConsolePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSConsolePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSConsole::s_info = { "Console", &Base::s_info, &JSConsoleTable, 0 , CREATE_METHOD_TABLE(JSConsole) };

JSConsole::JSConsole(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Console> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSConsole::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSConsole::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSConsolePrototype::create(exec->globalData(), globalObject, JSConsolePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSConsole::destroy(JSC::JSCell* cell)
{
    JSConsole* thisObject = static_cast<JSConsole*>(cell);
    thisObject->JSConsole::~JSConsole();
}

JSConsole::~JSConsole()
{
    releaseImplIfNotNull();
}

bool JSConsole::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSConsole* thisObject = jsCast<JSConsole*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSConsole, Base>(exec, &JSConsoleTable, thisObject, propertyName, slot);
}

bool JSConsole::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSConsole* thisObject = jsCast<JSConsole*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSConsole, Base>(exec, &JSConsoleTable, thisObject, propertyName, descriptor);
}

JSValue jsConsoleProfiles(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Console* impl = static_cast<Console*>(castedThis->impl());
    JSValue result = jsArray(exec, castedThis->globalObject(), impl->profiles());
    return result;
}


JSValue jsConsoleMemory(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Console* impl = static_cast<Console*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->memory()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDebug(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->debug(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionError(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->error(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionInfo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->info(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionLog(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->log(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionWarn(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->warn(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDir(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->dir(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDirxml(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->dirxml(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTrace(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->trace(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionAssert(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 1));
    bool condition(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->assertCondition(exec, scriptArguments.release(), condition);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionCount(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->count(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionMarkTimeline(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->markTimeline(scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    return JSValue::encode(castedThis->profile(exec));
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfileEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    return JSValue::encode(castedThis->profileEnd(exec));
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& title(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->time(title);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTimeEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& title(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->timeEnd(exec, title);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTimeStamp(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->timeStamp(scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroup(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->group(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupCollapsed(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->groupCollapsed(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    impl->groupEnd();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSConsole::s_info))
        return throwVMTypeError(exec);
    JSConsole* castedThis = jsCast<JSConsole*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSConsole::s_info);
    Console* impl = static_cast<Console*>(castedThis->impl());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(exec, 0));
    impl->clear(exec, scriptArguments.release());
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSConsole* jsConsole)
{
    if (jsConsole->hasCustomProperties())
        return true;
    return false;
}

bool JSConsoleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSConsole* jsConsole = jsCast<JSConsole*>(handle.get().asCell());
    if (!isObservable(jsConsole))
        return false;
    Frame* root = jsConsole->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSConsoleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSConsole* jsConsole = jsCast<JSConsole*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsConsole->impl(), jsConsole);
    jsConsole->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Console* impl)
{
    return wrap<JSConsole>(exec, globalObject, impl);
}

Console* toConsole(JSC::JSValue value)
{
    return value.inherits(&JSConsole::s_info) ? jsCast<JSConsole*>(asObject(value))->impl() : 0;
}

}
