/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSOverflowEvent.h"

#include "JSDictionary.h"
#include "OverflowEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSOverflowEventTableValues[] =
{
    { "orient", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventOrient), (intptr_t)0, NoIntrinsic },
    { "horizontalOverflow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHorizontalOverflow), (intptr_t)0, NoIntrinsic },
    { "verticalOverflow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVerticalOverflow), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOverflowEventTable = { 9, 7, JSOverflowEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSOverflowEventConstructorTableValues[] =
{
    { "HORIZONTAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHORIZONTAL), (intptr_t)0, NoIntrinsic },
    { "VERTICAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVERTICAL), (intptr_t)0, NoIntrinsic },
    { "BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventBOTH), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOverflowEventConstructorTable = { 9, 7, JSOverflowEventConstructorTableValues, 0 };

COMPILE_ASSERT(0 == OverflowEvent::HORIZONTAL, OverflowEventEnumHORIZONTALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OverflowEvent::VERTICAL, OverflowEventEnumVERTICALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OverflowEvent::BOTH, OverflowEventEnumBOTHIsWrongUseDoNotCheckConstants);

const ClassInfo JSOverflowEventConstructor::s_info = { "OverflowEventConstructor", &Base::s_info, &JSOverflowEventConstructorTable, 0, CREATE_METHOD_TABLE(JSOverflowEventConstructor) };

JSOverflowEventConstructor::JSOverflowEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSOverflowEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSOverflowEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSOverflowEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOverflowEventConstructor, JSDOMWrapper>(exec, &JSOverflowEventConstructorTable, jsCast<JSOverflowEventConstructor*>(cell), propertyName, slot);
}

bool JSOverflowEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOverflowEventConstructor, JSDOMWrapper>(exec, &JSOverflowEventConstructorTable, jsCast<JSOverflowEventConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSOverflowEventConstructor::constructJSOverflowEvent(ExecState* exec)
{
    JSOverflowEventConstructor* jsConstructor = jsCast<JSOverflowEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    OverflowEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillOverflowEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<OverflowEvent> event = OverflowEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillOverflowEventInit(OverflowEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("orient", eventInit.orient))
        return false;
    if (!dictionary.tryGetProperty("horizontalOverflow", eventInit.horizontalOverflow))
        return false;
    if (!dictionary.tryGetProperty("verticalOverflow", eventInit.verticalOverflow))
        return false;
    return true;
}

ConstructType JSOverflowEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSOverflowEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSOverflowEventPrototypeTableValues[] =
{
    { "HORIZONTAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHORIZONTAL), (intptr_t)0, NoIntrinsic },
    { "VERTICAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVERTICAL), (intptr_t)0, NoIntrinsic },
    { "BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventBOTH), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOverflowEventPrototypeTable = { 9, 7, JSOverflowEventPrototypeTableValues, 0 };
const ClassInfo JSOverflowEventPrototype::s_info = { "OverflowEventPrototype", &Base::s_info, &JSOverflowEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSOverflowEventPrototype) };

JSObject* JSOverflowEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOverflowEvent>(exec, globalObject);
}

bool JSOverflowEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSOverflowEventPrototype* thisObject = jsCast<JSOverflowEventPrototype*>(cell);
    return getStaticValueSlot<JSOverflowEventPrototype, JSObject>(exec, &JSOverflowEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSOverflowEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSOverflowEventPrototype* thisObject = jsCast<JSOverflowEventPrototype*>(object);
    return getStaticValueDescriptor<JSOverflowEventPrototype, JSObject>(exec, &JSOverflowEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSOverflowEvent::s_info = { "OverflowEvent", &Base::s_info, &JSOverflowEventTable, 0 , CREATE_METHOD_TABLE(JSOverflowEvent) };

JSOverflowEvent::JSOverflowEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OverflowEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSOverflowEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSOverflowEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOverflowEventPrototype::create(exec->globalData(), globalObject, JSOverflowEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSOverflowEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSOverflowEvent* thisObject = jsCast<JSOverflowEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSOverflowEvent, Base>(exec, &JSOverflowEventTable, thisObject, propertyName, slot);
}

bool JSOverflowEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSOverflowEvent* thisObject = jsCast<JSOverflowEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSOverflowEvent, Base>(exec, &JSOverflowEventTable, thisObject, propertyName, descriptor);
}

JSValue jsOverflowEventOrient(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOverflowEvent* castedThis = jsCast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* impl = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->orient());
    return result;
}


JSValue jsOverflowEventHorizontalOverflow(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOverflowEvent* castedThis = jsCast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* impl = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->horizontalOverflow());
    return result;
}


JSValue jsOverflowEventVerticalOverflow(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOverflowEvent* castedThis = jsCast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* impl = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->verticalOverflow());
    return result;
}


JSValue jsOverflowEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOverflowEvent* domObject = jsCast<JSOverflowEvent*>(asObject(slotBase));
    return JSOverflowEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSOverflowEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOverflowEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsOverflowEventHORIZONTAL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsOverflowEventVERTICAL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsOverflowEventBOTH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}
