/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGForeignObjectElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGForeignObjectElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementHeight), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementXmllang), (intptr_t)setJSSVGForeignObjectElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementXmlspace), (intptr_t)setJSSVGForeignObjectElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementStyle), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementTable = { 37, 31, JSSVGForeignObjectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGForeignObjectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementConstructorTable = { 1, 0, JSSVGForeignObjectElementConstructorTableValues, 0 };
const ClassInfo JSSVGForeignObjectElementConstructor::s_info = { "SVGForeignObjectElementConstructor", &Base::s_info, &JSSVGForeignObjectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGForeignObjectElementConstructor) };

JSSVGForeignObjectElementConstructor::JSSVGForeignObjectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGForeignObjectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGForeignObjectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGForeignObjectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGForeignObjectElementConstructor, JSDOMWrapper>(exec, &JSSVGForeignObjectElementConstructorTable, jsCast<JSSVGForeignObjectElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGForeignObjectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGForeignObjectElementConstructor, JSDOMWrapper>(exec, &JSSVGForeignObjectElementConstructorTable, jsCast<JSSVGForeignObjectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGForeignObjectElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGForeignObjectElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementPrototypeTable = { 17, 15, JSSVGForeignObjectElementPrototypeTableValues, 0 };
const ClassInfo JSSVGForeignObjectElementPrototype::s_info = { "SVGForeignObjectElementPrototype", &Base::s_info, &JSSVGForeignObjectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGForeignObjectElementPrototype) };

JSObject* JSSVGForeignObjectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGForeignObjectElement>(exec, globalObject);
}

bool JSSVGForeignObjectElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGForeignObjectElementPrototype* thisObject = jsCast<JSSVGForeignObjectElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGForeignObjectElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGForeignObjectElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGForeignObjectElementPrototype* thisObject = jsCast<JSSVGForeignObjectElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGForeignObjectElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGForeignObjectElement::s_info = { "SVGForeignObjectElement", &Base::s_info, &JSSVGForeignObjectElementTable, 0 , CREATE_METHOD_TABLE(JSSVGForeignObjectElement) };

JSSVGForeignObjectElement::JSSVGForeignObjectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGForeignObjectElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGForeignObjectElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGForeignObjectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGForeignObjectElementPrototype::create(exec->globalData(), globalObject, JSSVGForeignObjectElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGForeignObjectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGForeignObjectElement* thisObject = jsCast<JSSVGForeignObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGForeignObjectElement, Base>(exec, &JSSVGForeignObjectElementTable, thisObject, propertyName, slot);
}

bool JSSVGForeignObjectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGForeignObjectElement* thisObject = jsCast<JSSVGForeignObjectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGForeignObjectElement, Base>(exec, &JSSVGForeignObjectElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGForeignObjectElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGForeignObjectElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGForeignObjectElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGForeignObjectElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGForeignObjectElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGForeignObjectElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGForeignObjectElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGForeignObjectElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGForeignObjectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* domObject = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    return JSSVGForeignObjectElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGForeignObjectElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGForeignObjectElement* thisObject = jsCast<JSSVGForeignObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGForeignObjectElement, Base>(exec, propertyName, value, &JSSVGForeignObjectElementTable, thisObject, slot);
}

void setJSSVGForeignObjectElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(thisObject);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGForeignObjectElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(thisObject);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGForeignObjectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGForeignObjectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGForeignObjectElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGForeignObjectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGForeignObjectElement::s_info);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
