/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSProcessingInstruction.h"

#include "JSStyleSheet.h"
#include "KURL.h"
#include "ProcessingInstruction.h"
#include "StyleSheet.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSProcessingInstructionTableValues[] =
{
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionTarget), (intptr_t)0, NoIntrinsic },
    { "data", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionData), (intptr_t)setJSProcessingInstructionData, NoIntrinsic },
    { "sheet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionSheet), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSProcessingInstructionTable = { 8, 7, JSProcessingInstructionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSProcessingInstructionConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSProcessingInstructionConstructorTable = { 1, 0, JSProcessingInstructionConstructorTableValues, 0 };
const ClassInfo JSProcessingInstructionConstructor::s_info = { "ProcessingInstructionConstructor", &Base::s_info, &JSProcessingInstructionConstructorTable, 0, CREATE_METHOD_TABLE(JSProcessingInstructionConstructor) };

JSProcessingInstructionConstructor::JSProcessingInstructionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSProcessingInstructionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSProcessingInstructionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSProcessingInstructionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProcessingInstructionConstructor, JSDOMWrapper>(exec, &JSProcessingInstructionConstructorTable, jsCast<JSProcessingInstructionConstructor*>(cell), propertyName, slot);
}

bool JSProcessingInstructionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSProcessingInstructionConstructor, JSDOMWrapper>(exec, &JSProcessingInstructionConstructorTable, jsCast<JSProcessingInstructionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSProcessingInstructionPrototypeTable = { 1, 0, JSProcessingInstructionPrototypeTableValues, 0 };
const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstructionPrototype", &Base::s_info, &JSProcessingInstructionPrototypeTable, 0, CREATE_METHOD_TABLE(JSProcessingInstructionPrototype) };

JSObject* JSProcessingInstructionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSProcessingInstruction>(exec, globalObject);
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction", &Base::s_info, &JSProcessingInstructionTable, 0 , CREATE_METHOD_TABLE(JSProcessingInstruction) };

JSProcessingInstruction::JSProcessingInstruction(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ProcessingInstruction> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSProcessingInstruction::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSProcessingInstruction::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSProcessingInstructionPrototype::create(exec->globalData(), globalObject, JSProcessingInstructionPrototype::createStructure(exec->globalData(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSProcessingInstruction::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSProcessingInstruction* thisObject = jsCast<JSProcessingInstruction*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSProcessingInstruction, Base>(exec, &JSProcessingInstructionTable, thisObject, propertyName, slot);
}

bool JSProcessingInstruction::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSProcessingInstruction* thisObject = jsCast<JSProcessingInstruction*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSProcessingInstruction, Base>(exec, &JSProcessingInstructionTable, thisObject, propertyName, descriptor);
}

JSValue jsProcessingInstructionTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSProcessingInstruction* castedThis = jsCast<JSProcessingInstruction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ProcessingInstruction* impl = static_cast<ProcessingInstruction*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->target());
    return result;
}


JSValue jsProcessingInstructionData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSProcessingInstruction* castedThis = jsCast<JSProcessingInstruction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ProcessingInstruction* impl = static_cast<ProcessingInstruction*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->data());
    return result;
}


JSValue jsProcessingInstructionSheet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSProcessingInstruction* castedThis = jsCast<JSProcessingInstruction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ProcessingInstruction* impl = static_cast<ProcessingInstruction*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->sheet()));
    return result;
}


JSValue jsProcessingInstructionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSProcessingInstruction* domObject = jsCast<JSProcessingInstruction*>(asObject(slotBase));
    return JSProcessingInstruction::getConstructor(exec, domObject->globalObject());
}

void JSProcessingInstruction::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSProcessingInstruction* thisObject = jsCast<JSProcessingInstruction*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSProcessingInstruction, Base>(exec, propertyName, value, &JSProcessingInstructionTable, thisObject, slot);
}

void setJSProcessingInstructionData(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSProcessingInstruction* castedThis = jsCast<JSProcessingInstruction*>(thisObject);
    ProcessingInstruction* impl = static_cast<ProcessingInstruction*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setData(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSProcessingInstruction::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSProcessingInstructionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
