/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRange.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSRangeTableValues[] =
{
    { "startContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartContainer), (intptr_t)0, NoIntrinsic },
    { "startOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartOffset), (intptr_t)0, NoIntrinsic },
    { "endContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndContainer), (intptr_t)0, NoIntrinsic },
    { "endOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndOffset), (intptr_t)0, NoIntrinsic },
    { "collapsed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCollapsed), (intptr_t)0, NoIntrinsic },
    { "commonAncestorContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCommonAncestorContainer), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangeTable = { 18, 15, JSRangeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSRangeConstructorTableValues[] =
{
    { "START_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_START), (intptr_t)0, NoIntrinsic },
    { "START_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_END), (intptr_t)0, NoIntrinsic },
    { "END_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_END), (intptr_t)0, NoIntrinsic },
    { "END_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_START), (intptr_t)0, NoIntrinsic },
    { "NODE_BEFORE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE), (intptr_t)0, NoIntrinsic },
    { "NODE_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_AFTER), (intptr_t)0, NoIntrinsic },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE_AND_AFTER), (intptr_t)0, NoIntrinsic },
    { "NODE_INSIDE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_INSIDE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangeConstructorTable = { 18, 15, JSRangeConstructorTableValues, 0 };

COMPILE_ASSERT(0 == Range::START_TO_START, RangeEnumSTART_TO_STARTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Range::START_TO_END, RangeEnumSTART_TO_ENDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Range::END_TO_END, RangeEnumEND_TO_ENDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Range::END_TO_START, RangeEnumEND_TO_STARTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == Range::NODE_BEFORE, RangeEnumNODE_BEFOREIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Range::NODE_AFTER, RangeEnumNODE_AFTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Range::NODE_BEFORE_AND_AFTER, RangeEnumNODE_BEFORE_AND_AFTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Range::NODE_INSIDE, RangeEnumNODE_INSIDEIsWrongUseDoNotCheckConstants);

const ClassInfo JSRangeConstructor::s_info = { "RangeConstructor", &Base::s_info, &JSRangeConstructorTable, 0, CREATE_METHOD_TABLE(JSRangeConstructor) };

JSRangeConstructor::JSRangeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSRangeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSRangePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSRangeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeConstructor, JSDOMWrapper>(exec, &JSRangeConstructorTable, jsCast<JSRangeConstructor*>(cell), propertyName, slot);
}

bool JSRangeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRangeConstructor, JSDOMWrapper>(exec, &JSRangeConstructorTable, jsCast<JSRangeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSRangePrototypeTableValues[] =
{
    { "START_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_START), (intptr_t)0, NoIntrinsic },
    { "START_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_END), (intptr_t)0, NoIntrinsic },
    { "END_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_END), (intptr_t)0, NoIntrinsic },
    { "END_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_START), (intptr_t)0, NoIntrinsic },
    { "NODE_BEFORE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE), (intptr_t)0, NoIntrinsic },
    { "NODE_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_AFTER), (intptr_t)0, NoIntrinsic },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE_AND_AFTER), (intptr_t)0, NoIntrinsic },
    { "NODE_INSIDE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_INSIDE), (intptr_t)0, NoIntrinsic },
    { "setStart", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStart), (intptr_t)2, NoIntrinsic },
    { "setEnd", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEnd), (intptr_t)2, NoIntrinsic },
    { "setStartBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartBefore), (intptr_t)1, NoIntrinsic },
    { "setStartAfter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartAfter), (intptr_t)1, NoIntrinsic },
    { "setEndBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndBefore), (intptr_t)1, NoIntrinsic },
    { "setEndAfter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndAfter), (intptr_t)1, NoIntrinsic },
    { "collapse", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCollapse), (intptr_t)1, NoIntrinsic },
    { "selectNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNode), (intptr_t)1, NoIntrinsic },
    { "selectNodeContents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNodeContents), (intptr_t)1, NoIntrinsic },
    { "compareBoundaryPoints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareBoundaryPoints), (intptr_t)2, NoIntrinsic },
    { "deleteContents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDeleteContents), (intptr_t)0, NoIntrinsic },
    { "extractContents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExtractContents), (intptr_t)0, NoIntrinsic },
    { "cloneContents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneContents), (intptr_t)0, NoIntrinsic },
    { "insertNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionInsertNode), (intptr_t)1, NoIntrinsic },
    { "surroundContents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSurroundContents), (intptr_t)1, NoIntrinsic },
    { "cloneRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneRange), (intptr_t)0, NoIntrinsic },
    { "toString", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { "detach", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDetach), (intptr_t)0, NoIntrinsic },
    { "getClientRects", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetClientRects), (intptr_t)0, NoIntrinsic },
    { "getBoundingClientRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetBoundingClientRect), (intptr_t)0, NoIntrinsic },
    { "createContextualFragment", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCreateContextualFragment), (intptr_t)1, NoIntrinsic },
    { "intersectsNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIntersectsNode), (intptr_t)1, NoIntrinsic },
    { "compareNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareNode), (intptr_t)1, NoIntrinsic },
    { "comparePoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionComparePoint), (intptr_t)2, NoIntrinsic },
    { "isPointInRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIsPointInRange), (intptr_t)2, NoIntrinsic },
    { "expand", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExpand), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangePrototypeTable = { 132, 127, JSRangePrototypeTableValues, 0 };
const ClassInfo JSRangePrototype::s_info = { "RangePrototype", &Base::s_info, &JSRangePrototypeTable, 0, CREATE_METHOD_TABLE(JSRangePrototype) };

JSObject* JSRangePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRange>(exec, globalObject);
}

bool JSRangePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSRangePrototype* thisObject = jsCast<JSRangePrototype*>(cell);
    return getStaticPropertySlot<JSRangePrototype, JSObject>(exec, &JSRangePrototypeTable, thisObject, propertyName, slot);
}

bool JSRangePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSRangePrototype* thisObject = jsCast<JSRangePrototype*>(object);
    return getStaticPropertyDescriptor<JSRangePrototype, JSObject>(exec, &JSRangePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSRange::s_info = { "Range", &Base::s_info, &JSRangeTable, 0 , CREATE_METHOD_TABLE(JSRange) };

JSRange::JSRange(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Range> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSRange::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSRange::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSRangePrototype::create(exec->globalData(), globalObject, JSRangePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSRange::destroy(JSC::JSCell* cell)
{
    JSRange* thisObject = static_cast<JSRange*>(cell);
    thisObject->JSRange::~JSRange();
}

JSRange::~JSRange()
{
    releaseImplIfNotNull();
}

bool JSRange::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSRange* thisObject = jsCast<JSRange*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSRange, Base>(exec, &JSRangeTable, thisObject, propertyName, slot);
}

bool JSRange::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSRange* thisObject = jsCast<JSRange*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSRange, Base>(exec, &JSRangeTable, thisObject, propertyName, descriptor);
}

JSValue jsRangeStartContainer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->startContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeStartOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->startOffset(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeEndContainer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->endContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeEndOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->endOffset(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeCollapsed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsBoolean(impl->collapsed(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeCommonAncestorContainer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* castedThis = jsCast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* impl = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->commonAncestorContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRange* domObject = jsCast<JSRange*>(asObject(slotBase));
    return JSRange::getConstructor(exec, domObject->globalObject());
}

JSValue JSRange::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRangeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStart(refNode, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnd(refNode, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStartBefore(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartAfter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStartAfter(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEndBefore(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndAfter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEndAfter(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCollapse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    bool toStart(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->collapse(toStart, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->selectNode(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNodeContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->selectNodeContents(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareBoundaryPoints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Range::CompareHow how(static_cast<Range::CompareHow>(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* sourceRange(toRange(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->compareBoundaryPoints(how, sourceRange, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDeleteContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->deleteContents(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExtractContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->extractContents(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->cloneContents(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionInsertNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* newNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertNode(newNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSurroundContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* newParent(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->surroundContents(newParent, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->cloneRange(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsStringWithCache(exec, impl->toString(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDetach(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->detach(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetClientRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getClientRects()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetBoundingClientRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getBoundingClientRect()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCreateContextualFragment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& html(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createContextualFragment(html, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIntersectsNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->intersectsNode(refNode, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->compareNode(refNode, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionComparePoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->comparePoint(refNode, offset, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIsPointInRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPointInRange(refNode, offset, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExpand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = jsCast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* impl = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& unit(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->expand(unit, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsRangeSTART_TO_START(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsRangeSTART_TO_END(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsRangeEND_TO_END(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsRangeEND_TO_START(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsRangeNODE_BEFORE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsRangeNODE_AFTER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsRangeNODE_BEFORE_AND_AFTER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsRangeNODE_INSIDE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

static inline bool isObservable(JSRange* jsRange)
{
    if (jsRange->hasCustomProperties())
        return true;
    return false;
}

bool JSRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSRange* jsRange = jsCast<JSRange*>(handle.get().asCell());
    if (!isObservable(jsRange))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSRange* jsRange = jsCast<JSRange*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsRange->impl(), jsRange);
    jsRange->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Range* impl)
{
    return wrap<JSRange>(exec, globalObject, impl);
}

Range* toRange(JSC::JSValue value)
{
    return value.inherits(&JSRange::s_info) ? jsCast<JSRange*>(asObject(value))->impl() : 0;
}

}
