/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSScriptProfileNode_h
#define JSScriptProfileNode_h

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSDOMBinding.h"
#include "ScriptProfileNode.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSScriptProfileNode : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSScriptProfileNode* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ScriptProfileNode> impl)
    {
        JSScriptProfileNode* ptr = new (NotNull, JSC::allocateCell<JSScriptProfileNode>(globalObject->globalData().heap)) JSScriptProfileNode(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void destroy(JSC::JSCell*);
    ~JSScriptProfileNode();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    ScriptProfileNode* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull() { if (m_impl) { m_impl->deref(); m_impl = 0; } }

private:
    ScriptProfileNode* m_impl;
protected:
    JSScriptProfileNode(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<ScriptProfileNode>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSScriptProfileNodeOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, ScriptProfileNode*)
{
    DEFINE_STATIC_LOCAL(JSScriptProfileNodeOwner, jsScriptProfileNodeOwner, ());
    return &jsScriptProfileNodeOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, ScriptProfileNode*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, ScriptProfileNode*);
ScriptProfileNode* toScriptProfileNode(JSC::JSValue);

class JSScriptProfileNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSScriptProfileNodePrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScriptProfileNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSScriptProfileNodePrototype>(globalData.heap)) JSScriptProfileNodePrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSScriptProfileNodePrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsScriptProfileNodePrototypeFunctionChildren(JSC::ExecState*);
// Attributes

JSC::JSValue jsScriptProfileNodeFunctionName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeUrl(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeLineNumber(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeTotalTime(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeSelfTime(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeNumberOfCalls(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeVisible(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsScriptProfileNodeCallUID(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#endif
