/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGMONTHLYPLUGIN_H
#define SKGMONTHLYPLUGIN_H
/** @file
 * A plugin for monthly report.
*
* @author Stephane MANKOWSKI
 */
#include "skginterfaceplugin.h"

#ifdef SKG_WEBENGINE
class QWebEngineView;
#else
class QWebView;
#endif


/**
 * A plugin for monthly report
 */
class SKGMonthlyPlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin)

public:
    /**
     * Default Constructor
     */
    explicit SKGMonthlyPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    ~SKGMonthlyPlugin() override;

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    bool setupActions(SKGDocument* iDocument, const QStringList& iArgument) override;

    /**
     * The page widget of the plugin.
     * @return The page widget of the plugin
     */
    SKGTabPage* getWidget() override;

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    QString title() const override;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    QString icon() const override;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    QString toolTip() const override;

    /**
     * The tips list of the plugin.
     * @return The tips list of the plugin
     */
    QStringList tips() const override;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    int getOrder() const override;

    /**
     * Must be implemented to know if a plugin must be display in pages chooser.
     * @return true of false (default = false)
     */
    bool isInPagesChooser() const override;

private Q_SLOTS:
    void refreshMainPage();

private:
    Q_DISABLE_COPY(SKGMonthlyPlugin)

    SKGDocument* m_currentBankDocument;
#ifdef SKG_WEBENGINE
    QWebEngineView* m_mainPage;
#else
    QWebView* m_mainPage;
#endif
};

#endif  // SKGMonthlyPLUGIN_H
