/*
* Copyright(c) 2019 Netflix, Inc.
*
* This source code is subject to the terms of the BSD 2 Clause License and
* the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
* was not distributed with this source code in the LICENSE file, you can
* obtain it at https://www.aomedia.org/license/software-license. If the Alliance for Open
* Media Patent License 1.0 was not distributed with this source code in the
* PATENTS file, you can obtain it at https://www.aomedia.org/license/patent-license.
*/

#ifndef EbDecPicMgr_h
#define EbDecPicMgr_h

#ifdef __cplusplus
extern "C" {
#endif

/** Decoder Picture Manager **/
typedef struct EbDecPicMgr {
    /* Array of picture buffers */
    EbDecPicBuf as_dec_pic[MAX_PIC_BUFS];

    /* number of picture buffers */
    uint8_t num_pic_bufs;

} EbDecPicMgr;

typedef struct RefFrameInfo {
    int32_t      map_idx; /* frame map index */
    EbDecPicBuf *pic_buf; /* frame buffer */
    /* index based on the offset to be used for sorting */
    int32_t sort_idx;
} RefFrameInfo;

EbErrorType svt_aom_dec_pic_mgr_init(EbDecHandle *dec_handle_ptr);

EbDecPicBuf *svt_aom_dec_pic_mgr_get_cur_pic(EbDecHandle *dec_handle_ptr);

void svt_aom_dec_pic_mgr_update_ref_pic(EbDecHandle *dec_handle_ptr, int32_t frame_decoded,
                                        int32_t refresh_frame_flags);

void svt_aom_generate_next_ref_frame_map(EbDecHandle *dec_handle_ptr);

EbDecPicBuf *svt_aom_get_ref_frame_buf(EbDecHandle *dec_handle_ptr, const MvReferenceFrame ref_frame);
void         svt_setup_frame_buf_refs(EbDecHandle *dec_handle_ptr);

ScaleFactors *svt_aom_get_ref_scale_factors(EbDecHandle *dec_handle_ptr, const MvReferenceFrame ref_frame);

EbDecPicBuf *svt_aom_get_primary_ref_frame_buf(EbDecHandle *dec_handle_ptr);

void svt_set_frame_refs(EbDecHandle *dec_handle_ptr, int32_t lst_map_idx, int32_t gld_map_idx);

#ifdef __cplusplus
}
#endif
#endif // EbDecPicMgr_h
