/* valaccode.c generated by valac, the Vala compiler
 * generated from valaccode.vala, do not modify */

/* valaccode.vala
 *
 * Copyright (C) 2017  Rico Tzschichholz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Rico Tzschichholz <ricotz@ubuntu.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include "valacodegen.h"
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))


extern gint* vala_ccode_attribute_cache_index;
gint* vala_ccode_attribute_cache_index = NULL;

G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node);
static gint* _int_dup (gint* self);


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gpointer _vala_attribute_cache_ref0 (gpointer self) {
	return self ? vala_attribute_cache_ref (self) : NULL;
}


G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node) {
	ValaCCodeAttribute* result = NULL;
	gint* _tmp0_;
	ValaAttributeCache* attr = NULL;
	ValaCodeNode* _tmp3_;
	gint* _tmp4_;
	ValaAttributeCache* _tmp5_;
	ValaAttributeCache* _tmp6_;
	ValaAttributeCache* _tmp12_;
	ValaCCodeAttribute* _tmp13_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_attribute_cache_index;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_cache_index ();
		_tmp2_ = __int_dup0 (&_tmp1_);
		_g_free0 (vala_ccode_attribute_cache_index);
		vala_ccode_attribute_cache_index = _tmp2_;
	}
	_tmp3_ = node;
	_tmp4_ = vala_ccode_attribute_cache_index;
	_tmp5_ = vala_code_node_get_attribute_cache (_tmp3_, *_tmp4_);
	attr = _tmp5_;
	_tmp6_ = attr;
	if (_tmp6_ == NULL) {
		ValaCodeNode* _tmp7_;
		ValaCCodeAttribute* _tmp8_;
		ValaCodeNode* _tmp9_;
		gint* _tmp10_;
		ValaAttributeCache* _tmp11_;
		_tmp7_ = node;
		_tmp8_ = vala_ccode_attribute_new (_tmp7_);
		_vala_attribute_cache_unref0 (attr);
		attr = (ValaAttributeCache*) _tmp8_;
		_tmp9_ = node;
		_tmp10_ = vala_ccode_attribute_cache_index;
		_tmp11_ = attr;
		vala_code_node_set_attribute_cache (_tmp9_, *_tmp10_, _tmp11_);
	}
	_tmp12_ = attr;
	_tmp13_ = _vala_attribute_cache_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttribute));
	result = _tmp13_;
	_vala_attribute_cache_unref0 (attr);
	return result;
}


gchar* vala_get_ccode_name (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_const_name (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_const_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_type_name (ValaInterface* iface) {
	gchar* result = NULL;
	ValaInterface* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (iface != NULL, NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_type_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* vala_get_ccode_lower_case_name (ValaCodeNode* node, const gchar* infix) {
	gchar* result = NULL;
	ValaSymbol* sym = NULL;
	ValaCodeNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) _tmp0_) : NULL);
	sym = _tmp1_;
	_tmp2_ = sym;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = infix;
		if (_tmp3_ == NULL) {
			infix = "";
		}
		_tmp4_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_DELEGATE)) {
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			ValaSymbol* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp5_ = sym;
			_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_get_ccode_lower_case_prefix (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = infix;
			_tmp11_ = sym;
			_tmp12_ = vala_symbol_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_camel_case_to_lower_case (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp9_, _tmp10_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp9_);
			result = _tmp17_;
			_vala_code_node_unref0 (sym);
			return result;
		} else {
			ValaSymbol* _tmp18_;
			_tmp18_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_SIGNAL)) {
				ValaSymbol* _tmp19_;
				ValaCCodeAttribute* _tmp20_;
				ValaCCodeAttribute* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp19_ = sym;
				_tmp20_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_attribute_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = string_replace (_tmp23_, "-", "_");
				_tmp25_ = _tmp24_;
				_vala_attribute_cache_unref0 (_tmp21_);
				result = _tmp25_;
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				ValaSymbol* _tmp26_;
				_tmp26_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp27_ = sym;
					_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_utf8_strdown (_tmp29_, (gssize) -1);
					_tmp31_ = _tmp30_;
					_g_free0 (_tmp29_);
					result = _tmp31_;
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaSymbol* _tmp32_;
					ValaSymbol* _tmp33_;
					ValaSymbol* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					ValaSymbol* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp32_ = sym;
					_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_get_ccode_lower_case_prefix (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = infix;
					_tmp38_ = sym;
					_tmp39_ = vala_get_ccode_lower_case_suffix (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strdup_printf ("%s%s%s", _tmp36_, _tmp37_, _tmp40_);
					_tmp42_ = _tmp41_;
					_g_free0 (_tmp40_);
					_g_free0 (_tmp36_);
					result = _tmp42_;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
	} else {
		ValaCodeNode* _tmp43_;
		_tmp43_ = node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ERROR_TYPE)) {
			ValaErrorType* type = NULL;
			ValaCodeNode* _tmp44_;
			ValaErrorType* _tmp45_;
			ValaErrorType* _tmp46_;
			ValaErrorDomain* _tmp47_;
			ValaErrorDomain* _tmp48_;
			_tmp44_ = node;
			_tmp45_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
			type = _tmp45_;
			_tmp46_ = type;
			_tmp47_ = vala_error_type_get_error_domain (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ == NULL) {
				const gchar* _tmp49_;
				_tmp49_ = infix;
				if (_tmp49_ == NULL) {
					gchar* _tmp50_;
					_tmp50_ = g_strdup ("g_error");
					result = _tmp50_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp51_ = infix;
					_tmp52_ = g_strdup_printf ("g_%s_error", _tmp51_);
					result = _tmp52_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				}
			} else {
				ValaErrorType* _tmp53_;
				ValaErrorCode* _tmp54_;
				ValaErrorCode* _tmp55_;
				_tmp53_ = type;
				_tmp54_ = vala_error_type_get_error_code (_tmp53_);
				_tmp55_ = _tmp54_;
				if (_tmp55_ == NULL) {
					ValaErrorType* _tmp56_;
					ValaErrorDomain* _tmp57_;
					ValaErrorDomain* _tmp58_;
					const gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp56_ = type;
					_tmp57_ = vala_error_type_get_error_domain (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = infix;
					_tmp60_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp58_, _tmp59_);
					result = _tmp60_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaErrorType* _tmp61_;
					ValaErrorCode* _tmp62_;
					ValaErrorCode* _tmp63_;
					const gchar* _tmp64_;
					gchar* _tmp65_;
					_tmp61_ = type;
					_tmp62_ = vala_error_type_get_error_code (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = infix;
					_tmp65_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp63_, _tmp64_);
					result = _tmp65_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
			_vala_code_node_unref0 (type);
		} else {
			ValaCodeNode* _tmp66_;
			_tmp66_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegateType* type = NULL;
				ValaCodeNode* _tmp67_;
				ValaDelegateType* _tmp68_;
				ValaDelegateType* _tmp69_;
				ValaDelegate* _tmp70_;
				ValaDelegate* _tmp71_;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				_tmp67_ = node;
				_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				type = _tmp68_;
				_tmp69_ = type;
				_tmp70_ = vala_delegate_type_get_delegate_symbol (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = infix;
				_tmp73_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp71_, _tmp72_);
				result = _tmp73_;
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				ValaCodeNode* _tmp74_;
				_tmp74_ = node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_POINTER_TYPE)) {
					ValaPointerType* type = NULL;
					ValaCodeNode* _tmp75_;
					ValaPointerType* _tmp76_;
					ValaPointerType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					_tmp75_ = node;
					_tmp76_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					type = _tmp76_;
					_tmp77_ = type;
					_tmp78_ = vala_pointer_type_get_base_type (_tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = infix;
					_tmp81_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp79_, _tmp80_);
					result = _tmp81_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaCodeNode* _tmp82_;
					_tmp82_ = node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_GENERIC_TYPE)) {
						gchar* _tmp83_;
						_tmp83_ = g_strdup ("valageneric");
						result = _tmp83_;
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						ValaCodeNode* _tmp84_;
						_tmp84_ = node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_VOID_TYPE)) {
							gchar* _tmp85_;
							_tmp85_ = g_strdup ("valavoid");
							result = _tmp85_;
							_vala_code_node_unref0 (sym);
							return result;
						} else {
							ValaDataType* type = NULL;
							ValaCodeNode* _tmp86_;
							ValaDataType* _tmp87_;
							ValaDataType* _tmp88_;
							ValaTypeSymbol* _tmp89_;
							ValaTypeSymbol* _tmp90_;
							const gchar* _tmp91_;
							gchar* _tmp92_;
							_tmp86_ = node;
							_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DATA_TYPE, ValaDataType));
							type = _tmp87_;
							_tmp88_ = type;
							_tmp89_ = vala_data_type_get_data_type (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = infix;
							_tmp92_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp90_, _tmp91_);
							result = _tmp92_;
							_vala_code_node_unref0 (type);
							_vala_code_node_unref0 (sym);
							return result;
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}


gchar* vala_get_ccode_upper_case_name (ValaSymbol* sym, const gchar* infix) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_PROPERTY)) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaSymbol* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp1_ = sym;
		_tmp2_ = vala_symbol_get_parent_symbol (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = sym;
		_tmp7_ = vala_symbol_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_camel_case_to_lower_case (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s", _tmp5_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_ascii_strup (_tmp12_, (gssize) -1);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp5_);
		result = _tmp14_;
		return result;
	} else {
		ValaSymbol* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = sym;
		_tmp16_ = infix;
		_tmp17_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp15_, _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_ascii_strup (_tmp18_, (gssize) -1);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		result = _tmp20_;
		return result;
	}
}


gchar* vala_get_ccode_header_filenames (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_header_filenames (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_prefix (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_prefix (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_lower_case_prefix (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_lower_case_prefix (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_lower_case_suffix (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_lower_case_suffix (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_ref_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_ref_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_quark_name (ValaErrorDomain* edomain) {
	gchar* result = NULL;
	ValaErrorDomain* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (edomain != NULL, NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "-quark", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


gboolean vala_is_reference_counting (ValaTypeSymbol* sym) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = sym;
		_tmp2_ = vala_get_ccode_ref_function (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_ != NULL;
		_g_free0 (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		ValaTypeSymbol* _tmp5_;
		_tmp5_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_INTERFACE)) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}


gboolean vala_get_ccode_ref_function_void (ValaClass* cl) {
	gboolean result = FALSE;
	ValaClass* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = cl;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_ref_function_void (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gboolean vala_get_ccode_free_function_address_of (ValaClass* cl) {
	gboolean result = FALSE;
	ValaClass* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = cl;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_free_function_address_of (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_unref_function (ValaObjectTypeSymbol* sym) {
	gchar* result = NULL;
	ValaObjectTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_unref_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_ref_sink_function (ValaObjectTypeSymbol* sym) {
	gchar* result = NULL;
	ValaObjectTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_ref_sink_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_copy_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_copy_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_destroy_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_destroy_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_dup_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRUCT)) {
		ValaTypeSymbol* _tmp1_;
		ValaCCodeAttribute* _tmp2_;
		ValaCCodeAttribute* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = sym;
		_tmp2_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_attribute_get_dup_function (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = _tmp6_;
		_vala_attribute_cache_unref0 (_tmp3_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = sym;
	_tmp9_ = vala_get_ccode_copy_function (_tmp8_);
	result = _tmp9_;
	return result;
}


gchar* vala_get_ccode_free_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_free_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gboolean vala_get_ccode_is_gboxed (ValaTypeSymbol* sym) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_free_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "g_boxed_free") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean vala_get_ccode_finish_instance (ValaCodeNode* node) {
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_finish_instance (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_type_id (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_marshaller_type_name (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_marshaller_type_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_get_value_function (ValaCodeNode* sym) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_get_value_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_set_value_function (ValaCodeNode* sym) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_set_value_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_take_value_function (ValaCodeNode* sym) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_take_value_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_param_spec_function (ValaCodeNode* sym) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_param_spec_function (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_type_check_function (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaClass* cl = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaClass* _tmp1_;
	gchar* a = NULL;
	ValaTypeSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaClass* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp0_) : NULL);
	cl = _tmp1_;
	_tmp2_ = sym;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "type_check_function", NULL);
	a = _tmp3_;
	_tmp5_ = cl;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = a;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = a;
		_vala_code_node_unref0 (cl);
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaClass* _tmp11_;
		_tmp11_ = cl;
		if (_tmp11_ != NULL) {
			ValaClass* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = cl;
			_tmp13_ = vala_class_get_is_compact (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp15_;
			_tmp15_ = sym;
			_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_STRUCT);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp16_;
			_tmp16_ = sym;
			_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ENUM);
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp17_;
			_tmp17_ = sym;
			_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_DELEGATE);
		}
		if (_tmp7_) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("");
			result = _tmp18_;
			_g_free0 (a);
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaTypeSymbol* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = sym;
			_tmp20_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp19_, "IS_");
			result = _tmp20_;
			_g_free0 (a);
			_vala_code_node_unref0 (cl);
			return result;
		}
	}
	_g_free0 (a);
	_vala_code_node_unref0 (cl);
}


gchar* vala_get_ccode_default_value (ValaTypeSymbol* sym) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_default_value (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gboolean vala_get_ccode_has_copy_function (ValaStruct* st) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (st != NULL, FALSE);
	_tmp0_ = st;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "CCode", "has_copy_function", TRUE);
	result = _tmp1_;
	return result;
}


gboolean vala_get_ccode_has_destroy_function (ValaStruct* st) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (st != NULL, FALSE);
	_tmp0_ = st;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "CCode", "has_destroy_function", TRUE);
	result = _tmp1_;
	return result;
}


gdouble vala_get_ccode_instance_pos (ValaCodeNode* node) {
	gdouble result = 0.0;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_DELEGATE)) {
		ValaCodeNode* _tmp1_;
		gdouble _tmp2_;
		_tmp1_ = node;
		_tmp2_ = vala_code_node_get_attribute_double (_tmp1_, "CCode", "instance_pos", (gdouble) -2);
		result = _tmp2_;
		return result;
	} else {
		ValaCodeNode* _tmp3_;
		gdouble _tmp4_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_attribute_double (_tmp3_, "CCode", "instance_pos", (gdouble) 0);
		result = _tmp4_;
		return result;
	}
}


gboolean vala_get_ccode_array_length (ValaCodeNode* node) {
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_array_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_array_length_type (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_array_length_type (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gboolean vala_get_ccode_array_null_terminated (ValaCodeNode* node) {
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_array_null_terminated (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_array_length_name (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_array_length_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_array_length_expr (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_array_length_expr (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gdouble vala_get_ccode_array_length_pos (ValaCodeNode* node) {
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaCodeNode* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	ValaCodeNode* _tmp8_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_attribute (_tmp0_, "CCode");
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = a;
		_tmp5_ = vala_attribute_has_argument (_tmp4_, "array_length_pos");
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = a;
		_tmp7_ = vala_attribute_get_double (_tmp6_, "array_length_pos", (gdouble) 0);
		result = _tmp7_;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp8_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gdouble _tmp12_;
		_tmp9_ = node;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp10_;
		_tmp11_ = param;
		_tmp12_ = vala_get_ccode_pos (_tmp11_);
		result = _tmp12_ + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gdouble vala_get_ccode_delegate_target_pos (ValaCodeNode* node) {
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaCodeNode* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	ValaCodeNode* _tmp8_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_attribute (_tmp0_, "CCode");
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = a;
		_tmp5_ = vala_attribute_has_argument (_tmp4_, "delegate_target_pos");
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = a;
		_tmp7_ = vala_attribute_get_double (_tmp6_, "delegate_target_pos", (gdouble) 0);
		result = _tmp7_;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp8_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gdouble _tmp12_;
		_tmp9_ = node;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp10_;
		_tmp11_ = param;
		_tmp12_ = vala_get_ccode_pos (_tmp11_);
		result = _tmp12_ + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gdouble vala_get_ccode_destroy_notify_pos (ValaCodeNode* node) {
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaCodeNode* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	ValaCodeNode* _tmp8_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_attribute (_tmp0_, "CCode");
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = a;
		_tmp5_ = vala_attribute_has_argument (_tmp4_, "destroy_notify_pos");
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = a;
		_tmp7_ = vala_attribute_get_double (_tmp6_, "destroy_notify_pos", (gdouble) 0);
		result = _tmp7_;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp8_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gdouble _tmp12_;
		_tmp9_ = node;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp10_;
		_tmp11_ = param;
		_tmp12_ = vala_get_ccode_pos (_tmp11_);
		result = _tmp12_ + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gboolean vala_get_ccode_delegate_target (ValaCodeNode* node) {
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_delegate_target (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_delegate_target_name (ValaVariable* variable) {
	gchar* result = NULL;
	ValaVariable* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = variable;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_delegate_target_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gdouble vala_get_ccode_pos (ValaParameter* param) {
	gdouble result = 0.0;
	ValaParameter* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_val_if_fail (param != NULL, 0.0);
	_tmp0_ = param;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_pos (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_get_ccode_type (ValaCodeNode* node) {
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = vala_get_ccode_attribute (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_ctype (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gboolean vala_get_ccode_simple_generics (ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "CCode", "simple_generics", FALSE);
	result = _tmp1_;
	return result;
}


gchar* vala_get_ccode_real_name (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_real_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_constructv_name (ValaCreationMethod* m) {
	gchar* result = NULL;
	static const char infix[] = "constructv";
	ValaClass* parent = NULL;
	ValaCreationMethod* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaClass* _tmp3_;
	ValaCreationMethod* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp2_) : NULL);
	parent = _tmp3_;
	_tmp4_ = m;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp6_, ".new") == 0) {
		ValaClass* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = parent;
		_tmp8_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s%s", _tmp9_, infix);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		_vala_code_node_unref0 (parent);
		return result;
	} else {
		ValaClass* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaCreationMethod* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = parent;
		_tmp13_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = m;
		_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s%s_%s", _tmp14_, infix, _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp14_);
		result = _tmp19_;
		_vala_code_node_unref0 (parent);
		return result;
	}
	_vala_code_node_unref0 (parent);
}


gchar* vala_get_ccode_vfunc_name (ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_vfunc_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_finish_name (ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_finish_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_finish_vfunc_name (ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_finish_vfunc_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gchar* vala_get_ccode_finish_real_name (ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_finish_real_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


gboolean vala_get_ccode_no_accessor_method (ValaProperty* p) {
	gboolean result = FALSE;
	ValaProperty* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = p;
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp0_, "NoAccessorMethod");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_vala_code_node_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean vala_get_ccode_concrete_accessor (ValaProperty* p) {
	gboolean result = FALSE;
	ValaProperty* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = p;
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp0_, "ConcreteAccessor");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_vala_code_node_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean vala_get_ccode_has_type_id (ValaTypeSymbol* sym) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "CCode", "has_type_id", TRUE);
	result = _tmp1_;
	return result;
}


gboolean vala_get_ccode_has_new_function (ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "CCode", "has_new_function", TRUE);
	result = _tmp1_;
	return result;
}


gboolean vala_get_ccode_has_generic_type_parameter (ValaMethod* m) {
	gboolean result = FALSE;
	ValaAttribute* a = NULL;
	ValaMethod* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp0_, "CCode");
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = a;
		_tmp5_ = vala_attribute_has_argument (_tmp4_, "generic_type_pos");
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (a);
	return result;
}


gdouble vala_get_ccode_generic_type_pos (ValaMethod* m) {
	gdouble result = 0.0;
	ValaMethod* _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (m != NULL, 0.0);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute_double ((ValaCodeNode*) _tmp0_, "CCode", "generic_type_pos", (gdouble) 0);
	result = _tmp1_;
	return result;
}


gchar* vala_get_ccode_sentinel (ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_attribute_get_sentinel (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_attribute_cache_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}



