/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOListElement.h"

#include "HTMLNames.h"
#include "HTMLOListElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOListElementTableValues[] =
{
    { "compact", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOListElementCompact), (intptr_t)setJSHTMLOListElementCompact, NoIntrinsic },
    { "start", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOListElementStart), (intptr_t)setJSHTMLOListElementStart, NoIntrinsic },
    { "reversed", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOListElementReversed), (intptr_t)setJSHTMLOListElementReversed, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOListElementType), (intptr_t)setJSHTMLOListElementType, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOListElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOListElementTable = { 16, 15, JSHTMLOListElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLOListElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOListElementConstructorTable = { 1, 0, JSHTMLOListElementConstructorTableValues, 0 };
const ClassInfo JSHTMLOListElementConstructor::s_info = { "HTMLOListElementConstructor", &Base::s_info, &JSHTMLOListElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLOListElementConstructor) };

JSHTMLOListElementConstructor::JSHTMLOListElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLOListElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOListElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLOListElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOListElementConstructor, JSDOMWrapper>(exec, &JSHTMLOListElementConstructorTable, jsCast<JSHTMLOListElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLOListElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLOListElementConstructor, JSDOMWrapper>(exec, &JSHTMLOListElementConstructorTable, jsCast<JSHTMLOListElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOListElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOListElementPrototypeTable = { 1, 0, JSHTMLOListElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLOListElementPrototype::s_info = { "HTMLOListElementPrototype", &Base::s_info, &JSHTMLOListElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLOListElementPrototype) };

JSObject* JSHTMLOListElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOListElement>(exec, globalObject);
}

const ClassInfo JSHTMLOListElement::s_info = { "HTMLOListElement", &Base::s_info, &JSHTMLOListElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLOListElement) };

JSHTMLOListElement::JSHTMLOListElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLOListElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLOListElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLOListElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLOListElementPrototype::create(exec->globalData(), globalObject, JSHTMLOListElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOListElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLOListElement* thisObject = jsCast<JSHTMLOListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLOListElement, Base>(exec, &JSHTMLOListElementTable, thisObject, propertyName, slot);
}

bool JSHTMLOListElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLOListElement* thisObject = jsCast<JSHTMLOListElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLOListElement, Base>(exec, &JSHTMLOListElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLOListElementCompact(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::compactAttr));
    return result;
}


JSValue jsHTMLOListElementStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->start());
    return result;
}


JSValue jsHTMLOListElementReversed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::reversedAttr));
    return result;
}


JSValue jsHTMLOListElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLOListElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOListElement* domObject = jsCast<JSHTMLOListElement*>(asObject(slotBase));
    return JSHTMLOListElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLOListElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLOListElement* thisObject = jsCast<JSHTMLOListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLOListElement, Base>(exec, propertyName, value, &JSHTMLOListElementTable, thisObject, slot);
}

void setJSHTMLOListElementCompact(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(thisObject);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::compactAttr, value.toBoolean(exec));
}


void setJSHTMLOListElementStart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(thisObject);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    impl->setStart(value.toInt32(exec));
}


void setJSHTMLOListElementReversed(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(thisObject);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::reversedAttr, value.toBoolean(exec));
}


void setJSHTMLOListElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOListElement* castedThis = jsCast<JSHTMLOListElement*>(thisObject);
    HTMLOListElement* impl = static_cast<HTMLOListElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLOListElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOListElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
