/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMBarInfo.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMBarInfoPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_BAR_INFO_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_BAR_INFO, WebKitDOMBarInfoPrivate)

typedef struct _WebKitDOMBarInfoPrivate {
    RefPtr<WebCore::BarInfo> coreObject;
} WebKitDOMBarInfoPrivate;

namespace WebKit {

WebKitDOMBarInfo* kit(WebCore::BarInfo* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_BAR_INFO(ret);

    return wrapBarInfo(obj);
}

WebCore::BarInfo* core(WebKitDOMBarInfo* request)
{
    return request ? static_cast<WebCore::BarInfo*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMBarInfo* wrapBarInfo(WebCore::BarInfo* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_BAR_INFO(g_object_new(WEBKIT_TYPE_DOM_BAR_INFO, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMBarInfo, webkit_dom_bar_info, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_VISIBLE,
};

static void webkit_dom_bar_info_finalize(GObject* object)
{
    WebKitDOMBarInfoPrivate* priv = WEBKIT_DOM_BAR_INFO_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMBarInfoPrivate();
    G_OBJECT_CLASS(webkit_dom_bar_info_parent_class)->finalize(object);
}

static void webkit_dom_bar_info_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMBarInfo* self = WEBKIT_DOM_BAR_INFO(object);
    WebCore::BarInfo* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VISIBLE: {
        g_value_set_boolean(value, coreSelf->visible());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_bar_info_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_bar_info_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMBarInfoPrivate* priv = WEBKIT_DOM_BAR_INFO_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::BarInfo*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_bar_info_class_init(WebKitDOMBarInfoClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMBarInfoPrivate));
    gobjectClass->constructor = webkit_dom_bar_info_constructor;
    gobjectClass->finalize = webkit_dom_bar_info_finalize;
    gobjectClass->get_property = webkit_dom_bar_info_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VISIBLE,
                                    g_param_spec_boolean("visible", /* name */
                                                           "bar_info_visible", /* short description */
                                                           "read-only  gboolean BarInfo.visible", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_bar_info_init(WebKitDOMBarInfo* request)
{
    WebKitDOMBarInfoPrivate* priv = WEBKIT_DOM_BAR_INFO_GET_PRIVATE(request);
    new (priv) WebKitDOMBarInfoPrivate();
}

gboolean
webkit_dom_bar_info_get_visible(WebKitDOMBarInfo* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_BAR_INFO(self), FALSE);
    WebCore::BarInfo* item = WebKit::core(self);
    gboolean result = item->visible();
    return result;
}

