/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMPluginArray.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMPluginArrayPrivate.h"
#include "WebKitDOMDOMPluginPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_PLUGIN_ARRAY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_PLUGIN_ARRAY, WebKitDOMDOMPluginArrayPrivate)

typedef struct _WebKitDOMDOMPluginArrayPrivate {
    RefPtr<WebCore::DOMPluginArray> coreObject;
} WebKitDOMDOMPluginArrayPrivate;

namespace WebKit {

WebKitDOMDOMPluginArray* kit(WebCore::DOMPluginArray* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_PLUGIN_ARRAY(ret);

    return wrapDOMPluginArray(obj);
}

WebCore::DOMPluginArray* core(WebKitDOMDOMPluginArray* request)
{
    return request ? static_cast<WebCore::DOMPluginArray*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMPluginArray* wrapDOMPluginArray(WebCore::DOMPluginArray* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_PLUGIN_ARRAY(g_object_new(WEBKIT_TYPE_DOM_DOM_PLUGIN_ARRAY, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMPluginArray, webkit_dom_dom_plugin_array, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_dom_plugin_array_finalize(GObject* object)
{
    WebKitDOMDOMPluginArrayPrivate* priv = WEBKIT_DOM_DOM_PLUGIN_ARRAY_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMPluginArrayPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_plugin_array_parent_class)->finalize(object);
}

static void webkit_dom_dom_plugin_array_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMPluginArray* self = WEBKIT_DOM_DOM_PLUGIN_ARRAY(object);
    WebCore::DOMPluginArray* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_plugin_array_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_plugin_array_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMPluginArrayPrivate* priv = WEBKIT_DOM_DOM_PLUGIN_ARRAY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMPluginArray*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_plugin_array_class_init(WebKitDOMDOMPluginArrayClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMPluginArrayPrivate));
    gobjectClass->constructor = webkit_dom_dom_plugin_array_constructor;
    gobjectClass->finalize = webkit_dom_dom_plugin_array_finalize;
    gobjectClass->get_property = webkit_dom_dom_plugin_array_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "dom_plugin_array_length", /* short description */
                                                           "read-only  gulong DOMPluginArray.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_plugin_array_init(WebKitDOMDOMPluginArray* request)
{
    WebKitDOMDOMPluginArrayPrivate* priv = WEBKIT_DOM_DOM_PLUGIN_ARRAY_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMPluginArrayPrivate();
}

WebKitDOMDOMPlugin*
webkit_dom_dom_plugin_array_item(WebKitDOMDOMPluginArray* self, gulong index)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_PLUGIN_ARRAY(self), 0);
    WebCore::DOMPluginArray* item = WebKit::core(self);
    RefPtr<WebCore::DOMPlugin> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMPlugin*
webkit_dom_dom_plugin_array_named_item(WebKitDOMDOMPluginArray* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_PLUGIN_ARRAY(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::DOMPluginArray* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::DOMPlugin> gobjectResult = WTF::getPtr(item->namedItem(convertedName));
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_dom_plugin_array_refresh(WebKitDOMDOMPluginArray* self, gboolean reload)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_PLUGIN_ARRAY(self));
    WebCore::DOMPluginArray* item = WebKit::core(self);
    item->refresh(reload);
}

gulong
webkit_dom_dom_plugin_array_get_length(WebKitDOMDOMPluginArray* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_PLUGIN_ARRAY(self), 0);
    WebCore::DOMPluginArray* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

