/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMSecurityPolicy.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMSecurityPolicyPrivate.h"
#include "WebKitDOMDOMStringListPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_SECURITY_POLICY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_SECURITY_POLICY, WebKitDOMDOMSecurityPolicyPrivate)

typedef struct _WebKitDOMDOMSecurityPolicyPrivate {
#if ENABLE(CSP_NEXT)
    RefPtr<WebCore::DOMSecurityPolicy> coreObject;
#endif // ENABLE(CSP_NEXT)
} WebKitDOMDOMSecurityPolicyPrivate;

#if ENABLE(CSP_NEXT)

namespace WebKit {

WebKitDOMDOMSecurityPolicy* kit(WebCore::DOMSecurityPolicy* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_SECURITY_POLICY(ret);

    return wrapDOMSecurityPolicy(obj);
}

WebCore::DOMSecurityPolicy* core(WebKitDOMDOMSecurityPolicy* request)
{
    return request ? static_cast<WebCore::DOMSecurityPolicy*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMSecurityPolicy* wrapDOMSecurityPolicy(WebCore::DOMSecurityPolicy* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_SECURITY_POLICY(g_object_new(WEBKIT_TYPE_DOM_DOM_SECURITY_POLICY, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(CSP_NEXT)

G_DEFINE_TYPE(WebKitDOMDOMSecurityPolicy, webkit_dom_dom_security_policy, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ALLOWS_EVAL,
    PROP_ALLOWS_INLINE_SCRIPT,
    PROP_ALLOWS_INLINE_STYLE,
    PROP_IS_ACTIVE,
    PROP_REPORT_UR_IS,
};

static void webkit_dom_dom_security_policy_finalize(GObject* object)
{
    WebKitDOMDOMSecurityPolicyPrivate* priv = WEBKIT_DOM_DOM_SECURITY_POLICY_GET_PRIVATE(object);
#if ENABLE(CSP_NEXT)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(CSP_NEXT)
    priv->~WebKitDOMDOMSecurityPolicyPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_security_policy_parent_class)->finalize(object);
}

static void webkit_dom_dom_security_policy_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(CSP_NEXT)
    WebKitDOMDOMSecurityPolicy* self = WEBKIT_DOM_DOM_SECURITY_POLICY(object);
    WebCore::DOMSecurityPolicy* coreSelf = WebKit::core(self);
#endif // ENABLE(CSP_NEXT)
    switch (propertyId) {
    case PROP_ALLOWS_EVAL: {
#if ENABLE(CSP_NEXT)
        g_value_set_boolean(value, coreSelf->allowsEval());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    case PROP_ALLOWS_INLINE_SCRIPT: {
#if ENABLE(CSP_NEXT)
        g_value_set_boolean(value, coreSelf->allowsInlineScript());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    case PROP_ALLOWS_INLINE_STYLE: {
#if ENABLE(CSP_NEXT)
        g_value_set_boolean(value, coreSelf->allowsInlineStyle());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    case PROP_IS_ACTIVE: {
#if ENABLE(CSP_NEXT)
        g_value_set_boolean(value, coreSelf->isActive());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    case PROP_REPORT_UR_IS: {
#if ENABLE(CSP_NEXT)
        RefPtr<WebCore::DOMStringList> ptr = coreSelf->reportURIs();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_security_policy_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_security_policy_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(CSP_NEXT)
    WebKitDOMDOMSecurityPolicyPrivate* priv = WEBKIT_DOM_DOM_SECURITY_POLICY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMSecurityPolicy*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(CSP_NEXT)
    return object;
}

static void webkit_dom_dom_security_policy_class_init(WebKitDOMDOMSecurityPolicyClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMSecurityPolicyPrivate));
    gobjectClass->constructor = webkit_dom_dom_security_policy_constructor;
    gobjectClass->finalize = webkit_dom_dom_security_policy_finalize;
    gobjectClass->get_property = webkit_dom_dom_security_policy_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALLOWS_EVAL,
                                    g_param_spec_boolean("allows-eval", /* name */
                                                           "dom_security_policy_allows-eval", /* short description */
                                                           "read-only  gboolean DOMSecurityPolicy.allows-eval", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALLOWS_INLINE_SCRIPT,
                                    g_param_spec_boolean("allows-inline-script", /* name */
                                                           "dom_security_policy_allows-inline-script", /* short description */
                                                           "read-only  gboolean DOMSecurityPolicy.allows-inline-script", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALLOWS_INLINE_STYLE,
                                    g_param_spec_boolean("allows-inline-style", /* name */
                                                           "dom_security_policy_allows-inline-style", /* short description */
                                                           "read-only  gboolean DOMSecurityPolicy.allows-inline-style", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IS_ACTIVE,
                                    g_param_spec_boolean("is-active", /* name */
                                                           "dom_security_policy_is-active", /* short description */
                                                           "read-only  gboolean DOMSecurityPolicy.is-active", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REPORT_UR_IS,
                                    g_param_spec_object("report-ur-is", /* name */
                                                           "dom_security_policy_report-ur-is", /* short description */
                                                           "read-only  WebKitDOMDOMStringList* DOMSecurityPolicy.report-ur-is", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_STRING_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_security_policy_init(WebKitDOMDOMSecurityPolicy* request)
{
    WebKitDOMDOMSecurityPolicyPrivate* priv = WEBKIT_DOM_DOM_SECURITY_POLICY_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMSecurityPolicyPrivate();
}

gboolean
webkit_dom_dom_security_policy_allows_connection_to(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsConnectionTo(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_font_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsFontFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_form_action(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsFormAction(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_frame_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsFrameFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_image_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsImageFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_media_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsMediaFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_object_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsObjectFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_plugin_type(WebKitDOMDOMSecurityPolicy* self, const gchar* type)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(type, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedType = WTF::String::fromUTF8(type);
    gboolean result = item->allowsPluginType(convertedType);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_script_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsScriptFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_allows_style_from(WebKitDOMDOMSecurityPolicy* self, const gchar* url)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    g_return_val_if_fail(url, FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    gboolean result = item->allowsStyleFrom(convertedUrl);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_get_allows_eval(WebKitDOMDOMSecurityPolicy* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    gboolean result = item->allowsEval();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_get_allows_inline_script(WebKitDOMDOMSecurityPolicy* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    gboolean result = item->allowsInlineScript();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_get_allows_inline_style(WebKitDOMDOMSecurityPolicy* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    gboolean result = item->allowsInlineStyle();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

gboolean
webkit_dom_dom_security_policy_get_is_active(WebKitDOMDOMSecurityPolicy* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), FALSE);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    gboolean result = item->isActive();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSP_NEXT) */
}

WebKitDOMDOMStringList*
webkit_dom_dom_security_policy_get_report_ur_is(WebKitDOMDOMSecurityPolicy* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SECURITY_POLICY(self), 0);
    WebCore::DOMSecurityPolicy* item = WebKit::core(self);
    RefPtr<WebCore::DOMStringList> gobjectResult = WTF::getPtr(item->reportURIs());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return 0;
#endif /* ENABLE(CSP_NEXT) */
}

