/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMNodeFilter.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodeFilterPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_NODE_FILTER_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_NODE_FILTER, WebKitDOMNodeFilterPrivate)

typedef struct _WebKitDOMNodeFilterPrivate {
    RefPtr<WebCore::NodeFilter> coreObject;
} WebKitDOMNodeFilterPrivate;

namespace WebKit {

WebKitDOMNodeFilter* kit(WebCore::NodeFilter* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_NODE_FILTER(ret);

    return wrapNodeFilter(obj);
}

WebCore::NodeFilter* core(WebKitDOMNodeFilter* request)
{
    return request ? static_cast<WebCore::NodeFilter*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMNodeFilter* wrapNodeFilter(WebCore::NodeFilter* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_NODE_FILTER(g_object_new(WEBKIT_TYPE_DOM_NODE_FILTER, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMNodeFilter, webkit_dom_node_filter, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_node_filter_finalize(GObject* object)
{
    WebKitDOMNodeFilterPrivate* priv = WEBKIT_DOM_NODE_FILTER_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMNodeFilterPrivate();
    G_OBJECT_CLASS(webkit_dom_node_filter_parent_class)->finalize(object);
}

static GObject* webkit_dom_node_filter_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_node_filter_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMNodeFilterPrivate* priv = WEBKIT_DOM_NODE_FILTER_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::NodeFilter*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_node_filter_class_init(WebKitDOMNodeFilterClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMNodeFilterPrivate));
    gobjectClass->constructor = webkit_dom_node_filter_constructor;
    gobjectClass->finalize = webkit_dom_node_filter_finalize;
}

static void webkit_dom_node_filter_init(WebKitDOMNodeFilter* request)
{
    WebKitDOMNodeFilterPrivate* priv = WEBKIT_DOM_NODE_FILTER_GET_PRIVATE(request);
    new (priv) WebKitDOMNodeFilterPrivate();
}

gshort
webkit_dom_node_filter_accept_node(WebKitDOMNodeFilter* self, WebKitDOMNode* n)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_FILTER(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(n), 0);
    WebCore::NodeFilter* item = WebKit::core(self);
    WebCore::Node* convertedN = WebKit::core(n);
    gshort result = item->acceptNode(convertedN);
    return result;
}

