/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMShadowRoot.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMSelectionPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMShadowRootPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(SHADOW_DOM)

namespace WebKit {

WebKitDOMShadowRoot* kit(WebCore::ShadowRoot* obj)
{
    return WEBKIT_DOM_SHADOW_ROOT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::ShadowRoot* core(WebKitDOMShadowRoot* request)
{
    return request ? static_cast<WebCore::ShadowRoot*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMShadowRoot* wrapShadowRoot(WebCore::ShadowRoot* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_SHADOW_ROOT(g_object_new(WEBKIT_TYPE_DOM_SHADOW_ROOT, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(SHADOW_DOM)

G_DEFINE_TYPE(WebKitDOMShadowRoot, webkit_dom_shadow_root, WEBKIT_TYPE_DOM_DOCUMENT_FRAGMENT)

enum {
    PROP_0,
    PROP_ACTIVE_ELEMENT,
    PROP_APPLY_AUTHOR_STYLES,
    PROP_RESET_STYLE_INHERITANCE,
    PROP_INNER_HTML,
};

static void webkit_dom_shadow_root_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(SHADOW_DOM)
    WebKitDOMShadowRoot* self = WEBKIT_DOM_SHADOW_ROOT(object);
    WebCore::ShadowRoot* coreSelf = WebKit::core(self);
#endif // ENABLE(SHADOW_DOM)
    switch (propertyId) {
    case PROP_APPLY_AUTHOR_STYLES: {
#if ENABLE(SHADOW_DOM)
        coreSelf->setApplyAuthorStyles((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    case PROP_RESET_STYLE_INHERITANCE: {
#if ENABLE(SHADOW_DOM)
        coreSelf->setResetStyleInheritance((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    case PROP_INNER_HTML: {
#if ENABLE(SHADOW_DOM)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setInnerHTML(WTF::String::fromUTF8(g_value_get_string(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_shadow_root_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(SHADOW_DOM)
    WebKitDOMShadowRoot* self = WEBKIT_DOM_SHADOW_ROOT(object);
    WebCore::ShadowRoot* coreSelf = WebKit::core(self);
#endif // ENABLE(SHADOW_DOM)
    switch (propertyId) {
    case PROP_ACTIVE_ELEMENT: {
#if ENABLE(SHADOW_DOM)
        RefPtr<WebCore::Element> ptr = coreSelf->activeElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    case PROP_APPLY_AUTHOR_STYLES: {
#if ENABLE(SHADOW_DOM)
        g_value_set_boolean(value, coreSelf->applyAuthorStyles());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    case PROP_RESET_STYLE_INHERITANCE: {
#if ENABLE(SHADOW_DOM)
        g_value_set_boolean(value, coreSelf->resetStyleInheritance());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    case PROP_INNER_HTML: {
#if ENABLE(SHADOW_DOM)
        g_value_take_string(value, convertToUTF8String(coreSelf->innerHTML()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_shadow_root_class_init(WebKitDOMShadowRootClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_shadow_root_set_property;
    gobjectClass->get_property = webkit_dom_shadow_root_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ACTIVE_ELEMENT,
                                    g_param_spec_object("active-element", /* name */
                                                           "shadow_root_active-element", /* short description */
                                                           "read-only  WebKitDOMElement* ShadowRoot.active-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_APPLY_AUTHOR_STYLES,
                                    g_param_spec_boolean("apply-author-styles", /* name */
                                                           "shadow_root_apply-author-styles", /* short description */
                                                           "read-write  gboolean ShadowRoot.apply-author-styles", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RESET_STYLE_INHERITANCE,
                                    g_param_spec_boolean("reset-style-inheritance", /* name */
                                                           "shadow_root_reset-style-inheritance", /* short description */
                                                           "read-write  gboolean ShadowRoot.reset-style-inheritance", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INNER_HTML,
                                    g_param_spec_string("inner-html", /* name */
                                                           "shadow_root_inner-html", /* short description */
                                                           "read-write  gchar* ShadowRoot.inner-html", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_shadow_root_init(WebKitDOMShadowRoot* request)
{
}

WebKitDOMDOMSelection*
webkit_dom_shadow_root_get_selection(WebKitDOMShadowRoot* self)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    RefPtr<WebCore::DOMSelection> gobjectResult = WTF::getPtr(item->getSelection());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMElement*
webkit_dom_shadow_root_get_element_by_id(WebKitDOMShadowRoot* self, const gchar* elementId)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    g_return_val_if_fail(elementId, 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    WTF::String convertedElementId = WTF::String::fromUTF8(elementId);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->getElementById(convertedElementId));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMNodeList*
webkit_dom_shadow_root_get_elements_by_class_name(WebKitDOMShadowRoot* self, const gchar* className)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    g_return_val_if_fail(className, 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    WTF::String convertedClassName = WTF::String::fromUTF8(className);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByClassName(convertedClassName));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMNodeList*
webkit_dom_shadow_root_get_elements_by_tag_name(WebKitDOMShadowRoot* self, const gchar* tagName)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    g_return_val_if_fail(tagName, 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    WTF::String convertedTagName = WTF::String::fromUTF8(tagName);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagName(convertedTagName));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMNodeList*
webkit_dom_shadow_root_get_elements_by_tag_name_ns(WebKitDOMShadowRoot* self, const gchar* namespaceURI, const gchar* localName)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(localName, 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagNameNS(convertedNamespaceURI, convertedLocalName));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMElement*
webkit_dom_shadow_root_element_from_point(WebKitDOMShadowRoot* self, glong x, glong y)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->elementFromPoint(x, y));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

WebKitDOMElement*
webkit_dom_shadow_root_get_active_element(WebKitDOMShadowRoot* self)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->activeElement());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

gboolean
webkit_dom_shadow_root_get_apply_author_styles(WebKitDOMShadowRoot* self)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), FALSE);
    WebCore::ShadowRoot* item = WebKit::core(self);
    gboolean result = item->applyAuthorStyles();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SHADOW_DOM) */
}

void
webkit_dom_shadow_root_set_apply_author_styles(WebKitDOMShadowRoot* self, gboolean value)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self));
    WebCore::ShadowRoot* item = WebKit::core(self);
    item->setApplyAuthorStyles(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
}

gboolean
webkit_dom_shadow_root_get_reset_style_inheritance(WebKitDOMShadowRoot* self)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), FALSE);
    WebCore::ShadowRoot* item = WebKit::core(self);
    gboolean result = item->resetStyleInheritance();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return static_cast<gboolean>(0);
#endif /* ENABLE(SHADOW_DOM) */
}

void
webkit_dom_shadow_root_set_reset_style_inheritance(WebKitDOMShadowRoot* self, gboolean value)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self));
    WebCore::ShadowRoot* item = WebKit::core(self);
    item->setResetStyleInheritance(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
}

gchar*
webkit_dom_shadow_root_get_inner_html(WebKitDOMShadowRoot* self)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self), 0);
    WebCore::ShadowRoot* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->innerHTML());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
    return 0;
#endif /* ENABLE(SHADOW_DOM) */
}

void
webkit_dom_shadow_root_set_inner_html(WebKitDOMShadowRoot* self, const gchar* value, GError** error)
{
#if ENABLE(SHADOW_DOM)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_SHADOW_ROOT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::ShadowRoot* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setInnerHTML(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Shadow Dom")
#endif /* ENABLE(SHADOW_DOM) */
}

