/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeType.h"

#include "DOMMimeType.h"
#include "DOMPlugin.h"
#include "JSDOMPlugin.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMMimeTypeTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeType), (intptr_t)0, NoIntrinsic },
    { "suffixes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeSuffixes), (intptr_t)0, NoIntrinsic },
    { "description", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeDescription), (intptr_t)0, NoIntrinsic },
    { "enabledPlugin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeEnabledPlugin), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypeTable = { 16, 15, JSDOMMimeTypeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMMimeTypeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypeConstructorTable = { 1, 0, JSDOMMimeTypeConstructorTableValues, 0 };
const ClassInfo JSDOMMimeTypeConstructor::s_info = { "MimeTypeConstructor", &Base::s_info, &JSDOMMimeTypeConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeConstructor) };

JSDOMMimeTypeConstructor::JSDOMMimeTypeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMMimeTypeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMMimeTypePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMMimeTypeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMMimeTypeConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeConstructorTable, jsCast<JSDOMMimeTypeConstructor*>(cell), propertyName, slot);
}

bool JSDOMMimeTypeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMMimeTypeConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeConstructorTable, jsCast<JSDOMMimeTypeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypePrototypeTable = { 1, 0, JSDOMMimeTypePrototypeTableValues, 0 };
const ClassInfo JSDOMMimeTypePrototype::s_info = { "MimeTypePrototype", &Base::s_info, &JSDOMMimeTypePrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMMimeTypePrototype) };

JSObject* JSDOMMimeTypePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMMimeType>(exec, globalObject);
}

const ClassInfo JSDOMMimeType::s_info = { "MimeType", &Base::s_info, &JSDOMMimeTypeTable, 0 , CREATE_METHOD_TABLE(JSDOMMimeType) };

JSDOMMimeType::JSDOMMimeType(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMMimeType> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMMimeType::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMMimeType::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMMimeTypePrototype::create(exec->globalData(), globalObject, JSDOMMimeTypePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSDOMMimeType::destroy(JSC::JSCell* cell)
{
    JSDOMMimeType* thisObject = static_cast<JSDOMMimeType*>(cell);
    thisObject->JSDOMMimeType::~JSDOMMimeType();
}

JSDOMMimeType::~JSDOMMimeType()
{
    releaseImplIfNotNull();
}

bool JSDOMMimeType::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMMimeType* thisObject = jsCast<JSDOMMimeType*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMMimeType, Base>(exec, &JSDOMMimeTypeTable, thisObject, propertyName, slot);
}

bool JSDOMMimeType::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMMimeType* thisObject = jsCast<JSDOMMimeType*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMMimeType, Base>(exec, &JSDOMMimeTypeTable, thisObject, propertyName, descriptor);
}

JSValue jsDOMMimeTypeType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeType* castedThis = jsCast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* impl = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsDOMMimeTypeSuffixes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeType* castedThis = jsCast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* impl = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->suffixes());
    return result;
}


JSValue jsDOMMimeTypeDescription(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeType* castedThis = jsCast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* impl = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->description());
    return result;
}


JSValue jsDOMMimeTypeEnabledPlugin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeType* castedThis = jsCast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* impl = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->enabledPlugin()));
    return result;
}


JSValue jsDOMMimeTypeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeType* domObject = jsCast<JSDOMMimeType*>(asObject(slotBase));
    return JSDOMMimeType::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMMimeType::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSDOMMimeType* jsDOMMimeType)
{
    if (jsDOMMimeType->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMMimeTypeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMMimeType* jsDOMMimeType = jsCast<JSDOMMimeType*>(handle.get().asCell());
    if (!isObservable(jsDOMMimeType))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMMimeTypeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMMimeType* jsDOMMimeType = jsCast<JSDOMMimeType*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMMimeType->impl(), jsDOMMimeType);
    jsDOMMimeType->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMMimeType* impl)
{
    return wrap<JSDOMMimeType>(exec, globalObject, impl);
}

DOMMimeType* toDOMMimeType(JSC::JSValue value)
{
    return value.inherits(&JSDOMMimeType::s_info) ? jsCast<JSDOMMimeType*>(asObject(value))->impl() : 0;
}

}
