/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLUListElement.h"

#include "HTMLNames.h"
#include "HTMLUListElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLUListElementTableValues[] =
{
    { "compact", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementCompact), (intptr_t)setJSHTMLUListElementCompact, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementType), (intptr_t)setJSHTMLUListElementType, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLUListElementTable = { 8, 7, JSHTMLUListElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLUListElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLUListElementConstructorTable = { 1, 0, JSHTMLUListElementConstructorTableValues, 0 };
const ClassInfo JSHTMLUListElementConstructor::s_info = { "HTMLUListElementConstructor", &Base::s_info, &JSHTMLUListElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLUListElementConstructor) };

JSHTMLUListElementConstructor::JSHTMLUListElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLUListElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLUListElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLUListElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLUListElementConstructor, JSDOMWrapper>(exec, &JSHTMLUListElementConstructorTable, jsCast<JSHTMLUListElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLUListElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLUListElementConstructor, JSDOMWrapper>(exec, &JSHTMLUListElementConstructorTable, jsCast<JSHTMLUListElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLUListElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLUListElementPrototypeTable = { 1, 0, JSHTMLUListElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLUListElementPrototype::s_info = { "HTMLUListElementPrototype", &Base::s_info, &JSHTMLUListElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLUListElementPrototype) };

JSObject* JSHTMLUListElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLUListElement>(exec, globalObject);
}

const ClassInfo JSHTMLUListElement::s_info = { "HTMLUListElement", &Base::s_info, &JSHTMLUListElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLUListElement) };

JSHTMLUListElement::JSHTMLUListElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLUListElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLUListElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLUListElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLUListElementPrototype::create(exec->globalData(), globalObject, JSHTMLUListElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLUListElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLUListElement* thisObject = jsCast<JSHTMLUListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLUListElement, Base>(exec, &JSHTMLUListElementTable, thisObject, propertyName, slot);
}

bool JSHTMLUListElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLUListElement* thisObject = jsCast<JSHTMLUListElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLUListElement, Base>(exec, &JSHTMLUListElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLUListElementCompact(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLUListElement* castedThis = jsCast<JSHTMLUListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLUListElement* impl = static_cast<HTMLUListElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::compactAttr));
    return result;
}


JSValue jsHTMLUListElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLUListElement* castedThis = jsCast<JSHTMLUListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLUListElement* impl = static_cast<HTMLUListElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLUListElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLUListElement* domObject = jsCast<JSHTMLUListElement*>(asObject(slotBase));
    return JSHTMLUListElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLUListElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLUListElement* thisObject = jsCast<JSHTMLUListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLUListElement, Base>(exec, propertyName, value, &JSHTMLUListElementTable, thisObject, slot);
}

void setJSHTMLUListElementCompact(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLUListElement* castedThis = jsCast<JSHTMLUListElement*>(thisObject);
    HTMLUListElement* impl = static_cast<HTMLUListElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::compactAttr, value.toBoolean(exec));
}


void setJSHTMLUListElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLUListElement* castedThis = jsCast<JSHTMLUListElement*>(thisObject);
    HTMLUListElement* impl = static_cast<HTMLUListElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLUListElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLUListElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
