/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleSheetList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSStyleSheet.h"
#include "StyleSheet.h"
#include "StyleSheetList.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSStyleSheetListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleSheetListTable = { 5, 3, JSStyleSheetListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSStyleSheetListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleSheetListConstructorTable = { 1, 0, JSStyleSheetListConstructorTableValues, 0 };
const ClassInfo JSStyleSheetListConstructor::s_info = { "StyleSheetListConstructor", &Base::s_info, &JSStyleSheetListConstructorTable, 0, CREATE_METHOD_TABLE(JSStyleSheetListConstructor) };

JSStyleSheetListConstructor::JSStyleSheetListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSStyleSheetListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSStyleSheetListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSStyleSheetListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheetListConstructor, JSDOMWrapper>(exec, &JSStyleSheetListConstructorTable, jsCast<JSStyleSheetListConstructor*>(cell), propertyName, slot);
}

bool JSStyleSheetListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStyleSheetListConstructor, JSDOMWrapper>(exec, &JSStyleSheetListConstructorTable, jsCast<JSStyleSheetListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSStyleSheetListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStyleSheetListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleSheetListPrototypeTable = { 2, 1, JSStyleSheetListPrototypeTableValues, 0 };
const ClassInfo JSStyleSheetListPrototype::s_info = { "StyleSheetListPrototype", &Base::s_info, &JSStyleSheetListPrototypeTable, 0, CREATE_METHOD_TABLE(JSStyleSheetListPrototype) };

JSObject* JSStyleSheetListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStyleSheetList>(exec, globalObject);
}

bool JSStyleSheetListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStyleSheetListPrototype* thisObject = jsCast<JSStyleSheetListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSStyleSheetListPrototypeTable, thisObject, propertyName, slot);
}

bool JSStyleSheetListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStyleSheetListPrototype* thisObject = jsCast<JSStyleSheetListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStyleSheetListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStyleSheetList::s_info = { "StyleSheetList", &Base::s_info, &JSStyleSheetListTable, 0 , CREATE_METHOD_TABLE(JSStyleSheetList) };

JSStyleSheetList::JSStyleSheetList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<StyleSheetList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSStyleSheetList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSStyleSheetList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStyleSheetListPrototype::create(exec->globalData(), globalObject, JSStyleSheetListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSStyleSheetList::destroy(JSC::JSCell* cell)
{
    JSStyleSheetList* thisObject = static_cast<JSStyleSheetList*>(cell);
    thisObject->JSStyleSheetList::~JSStyleSheetList();
}

JSStyleSheetList::~JSStyleSheetList()
{
    releaseImplIfNotNull();
}

bool JSStyleSheetList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStyleSheetList* thisObject = jsCast<JSStyleSheetList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSStyleSheetList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<StyleSheetList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<StyleSheetList*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSStyleSheetList, Base>(exec, &JSStyleSheetListTable, thisObject, propertyName, slot);
}

bool JSStyleSheetList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStyleSheetList* thisObject = jsCast<JSStyleSheetList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSStyleSheetListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<StyleSheetList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<StyleSheetList*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSStyleSheetList, Base>(exec, &JSStyleSheetListTable, thisObject, propertyName, descriptor);
}

bool JSStyleSheetList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSStyleSheetList* thisObject = jsCast<JSStyleSheetList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<StyleSheetList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<StyleSheetList*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsStyleSheetListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStyleSheetList* castedThis = jsCast<JSStyleSheetList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StyleSheetList* impl = static_cast<StyleSheetList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsStyleSheetListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStyleSheetList* domObject = jsCast<JSStyleSheetList*>(asObject(slotBase));
    return JSStyleSheetList::getConstructor(exec, domObject->globalObject());
}

void JSStyleSheetList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSStyleSheetList* thisObject = jsCast<JSStyleSheetList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<StyleSheetList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSStyleSheetList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStyleSheetListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStyleSheetListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStyleSheetList::s_info))
        return throwVMTypeError(exec);
    JSStyleSheetList* castedThis = jsCast<JSStyleSheetList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStyleSheetList::s_info);
    StyleSheetList* impl = static_cast<StyleSheetList*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSStyleSheetList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSStyleSheetList* thisObj = jsCast<JSStyleSheetList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<StyleSheetList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSStyleSheetList* jsStyleSheetList)
{
    if (jsStyleSheetList->hasCustomProperties())
        return true;
    return false;
}

bool JSStyleSheetListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSStyleSheetList* jsStyleSheetList = jsCast<JSStyleSheetList*>(handle.get().asCell());
    if (!isObservable(jsStyleSheetList))
        return false;
    Document* root = jsStyleSheetList->impl()->document();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSStyleSheetListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSStyleSheetList* jsStyleSheetList = jsCast<JSStyleSheetList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStyleSheetList->impl(), jsStyleSheetList);
    jsStyleSheetList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, StyleSheetList* impl)
{
    return wrap<JSStyleSheetList>(exec, globalObject, impl);
}

StyleSheetList* toStyleSheetList(JSC::JSValue value)
{
    return value.inherits(&JSStyleSheetList::s_info) ? jsCast<JSStyleSheetList*>(asObject(value))->impl() : 0;
}

}
