/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMEvent.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTargetPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_EVENT_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_EVENT, WebKitDOMEventPrivate)

typedef struct _WebKitDOMEventPrivate {
    RefPtr<WebCore::Event> coreObject;
} WebKitDOMEventPrivate;

namespace WebKit {

WebKitDOMEvent* kit(WebCore::Event* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_EVENT(ret);

    return wrap(obj);
}

WebCore::Event* core(WebKitDOMEvent* request)
{
    return request ? static_cast<WebCore::Event*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMEvent* wrapEvent(WebCore::Event* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_EVENT(g_object_new(WEBKIT_TYPE_DOM_EVENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMEvent, webkit_dom_event, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_TARGET,
    PROP_CURRENT_TARGET,
    PROP_EVENT_PHASE,
    PROP_BUBBLES,
    PROP_CANCELABLE,
    PROP_TIME_STAMP,
    PROP_DEFAULT_PREVENTED,
    PROP_SRC_ELEMENT,
    PROP_RETURN_VALUE,
    PROP_CANCEL_BUBBLE,
};

static void webkit_dom_event_finalize(GObject* object)
{
    WebKitDOMEventPrivate* priv = WEBKIT_DOM_EVENT_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMEventPrivate();
    G_OBJECT_CLASS(webkit_dom_event_parent_class)->finalize(object);
}

static void webkit_dom_event_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMEvent* self = WEBKIT_DOM_EVENT(object);
    WebCore::Event* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_RETURN_VALUE: {
        coreSelf->setReturnValue((g_value_get_boolean(value)));
        break;
    }
    case PROP_CANCEL_BUBBLE: {
        coreSelf->setCancelBubble((g_value_get_boolean(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_event_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMEvent* self = WEBKIT_DOM_EVENT(object);
    WebCore::Event* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_TARGET: {
        RefPtr<WebCore::EventTarget> ptr = coreSelf->target();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CURRENT_TARGET: {
        RefPtr<WebCore::EventTarget> ptr = coreSelf->currentTarget();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_EVENT_PHASE: {
        g_value_set_uint(value, coreSelf->eventPhase());
        break;
    }
    case PROP_BUBBLES: {
        g_value_set_boolean(value, coreSelf->bubbles());
        break;
    }
    case PROP_CANCELABLE: {
        g_value_set_boolean(value, coreSelf->cancelable());
        break;
    }
    case PROP_TIME_STAMP: {
        g_value_set_uint(value, coreSelf->timeStamp());
        break;
    }
    case PROP_DEFAULT_PREVENTED: {
        g_value_set_boolean(value, coreSelf->defaultPrevented());
        break;
    }
    case PROP_SRC_ELEMENT: {
        RefPtr<WebCore::EventTarget> ptr = coreSelf->srcElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_RETURN_VALUE: {
        g_value_set_boolean(value, coreSelf->returnValue());
        break;
    }
    case PROP_CANCEL_BUBBLE: {
        g_value_set_boolean(value, coreSelf->cancelBubble());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_event_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_event_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMEventPrivate* priv = WEBKIT_DOM_EVENT_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Event*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_event_class_init(WebKitDOMEventClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMEventPrivate));
    gobjectClass->constructor = webkit_dom_event_constructor;
    gobjectClass->finalize = webkit_dom_event_finalize;
    gobjectClass->set_property = webkit_dom_event_set_property;
    gobjectClass->get_property = webkit_dom_event_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "event_type", /* short description */
                                                           "read-only  gchar* Event.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_object("target", /* name */
                                                           "event_target", /* short description */
                                                           "read-only  WebKitDOMEventTarget* Event.target", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_EVENT_TARGET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CURRENT_TARGET,
                                    g_param_spec_object("current-target", /* name */
                                                           "event_current-target", /* short description */
                                                           "read-only  WebKitDOMEventTarget* Event.current-target", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_EVENT_TARGET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EVENT_PHASE,
                                    g_param_spec_uint("event-phase", /* name */
                                                           "event_event-phase", /* short description */
                                                           "read-only  gushort Event.event-phase", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BUBBLES,
                                    g_param_spec_boolean("bubbles", /* name */
                                                           "event_bubbles", /* short description */
                                                           "read-only  gboolean Event.bubbles", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CANCELABLE,
                                    g_param_spec_boolean("cancelable", /* name */
                                                           "event_cancelable", /* short description */
                                                           "read-only  gboolean Event.cancelable", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TIME_STAMP,
                                    g_param_spec_uint("time-stamp", /* name */
                                                           "event_time-stamp", /* short description */
                                                           "read-only  guint32 Event.time-stamp", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_PREVENTED,
                                    g_param_spec_boolean("default-prevented", /* name */
                                                           "event_default-prevented", /* short description */
                                                           "read-only  gboolean Event.default-prevented", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC_ELEMENT,
                                    g_param_spec_object("src-element", /* name */
                                                           "event_src-element", /* short description */
                                                           "read-only  WebKitDOMEventTarget* Event.src-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_EVENT_TARGET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RETURN_VALUE,
                                    g_param_spec_boolean("return-value", /* name */
                                                           "event_return-value", /* short description */
                                                           "read-write  gboolean Event.return-value", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CANCEL_BUBBLE,
                                    g_param_spec_boolean("cancel-bubble", /* name */
                                                           "event_cancel-bubble", /* short description */
                                                           "read-write  gboolean Event.cancel-bubble", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_event_init(WebKitDOMEvent* request)
{
    WebKitDOMEventPrivate* priv = WEBKIT_DOM_EVENT_GET_PRIVATE(request);
    new (priv) WebKitDOMEventPrivate();
}

void
webkit_dom_event_stop_propagation(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    WebCore::Event* item = WebKit::core(self);
    item->stopPropagation();
}

void
webkit_dom_event_prevent_default(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    WebCore::Event* item = WebKit::core(self);
    item->preventDefault();
}

void
webkit_dom_event_init_event(WebKitDOMEvent* self, const gchar* eventTypeArg, gboolean canBubbleArg, gboolean cancelableArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    g_return_if_fail(eventTypeArg);
    WebCore::Event* item = WebKit::core(self);
    WTF::String convertedEventTypeArg = WTF::String::fromUTF8(eventTypeArg);
    item->initEvent(convertedEventTypeArg, canBubbleArg, cancelableArg);
}

void
webkit_dom_event_stop_immediate_propagation(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    WebCore::Event* item = WebKit::core(self);
    item->stopImmediatePropagation();
}

WebKitDOMEventTarget*
webkit_dom_event_get_target(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), 0);
    WebCore::Event* item = WebKit::core(self);
    RefPtr<WebCore::EventTarget> gobjectResult = WTF::getPtr(item->target());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMEventTarget*
webkit_dom_event_get_current_target(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), 0);
    WebCore::Event* item = WebKit::core(self);
    RefPtr<WebCore::EventTarget> gobjectResult = WTF::getPtr(item->currentTarget());
    return WebKit::kit(gobjectResult.get());
}

gushort
webkit_dom_event_get_event_phase(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), 0);
    WebCore::Event* item = WebKit::core(self);
    gushort result = item->eventPhase();
    return result;
}

gboolean
webkit_dom_event_get_bubbles(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), FALSE);
    WebCore::Event* item = WebKit::core(self);
    gboolean result = item->bubbles();
    return result;
}

gboolean
webkit_dom_event_get_cancelable(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), FALSE);
    WebCore::Event* item = WebKit::core(self);
    gboolean result = item->cancelable();
    return result;
}

guint32
webkit_dom_event_get_time_stamp(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), 0);
    WebCore::Event* item = WebKit::core(self);
    guint32 result = item->timeStamp();
    return result;
}

gboolean
webkit_dom_event_get_default_prevented(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), FALSE);
    WebCore::Event* item = WebKit::core(self);
    gboolean result = item->defaultPrevented();
    return result;
}

WebKitDOMEventTarget*
webkit_dom_event_get_src_element(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), 0);
    WebCore::Event* item = WebKit::core(self);
    RefPtr<WebCore::EventTarget> gobjectResult = WTF::getPtr(item->srcElement());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_event_get_return_value(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), FALSE);
    WebCore::Event* item = WebKit::core(self);
    gboolean result = item->returnValue();
    return result;
}

void
webkit_dom_event_set_return_value(WebKitDOMEvent* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    WebCore::Event* item = WebKit::core(self);
    item->setReturnValue(value);
}

gboolean
webkit_dom_event_get_cancel_bubble(WebKitDOMEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(self), FALSE);
    WebCore::Event* item = WebKit::core(self);
    gboolean result = item->cancelBubble();
    return result;
}

void
webkit_dom_event_set_cancel_bubble(WebKitDOMEvent* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_EVENT(self));
    WebCore::Event* item = WebKit::core(self);
    item->setCancelBubble(value);
}

