/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMGeolocation.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMGeolocationPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_GEOLOCATION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_GEOLOCATION, WebKitDOMGeolocationPrivate)

typedef struct _WebKitDOMGeolocationPrivate {
#if ENABLE(GEOLOCATION)
    RefPtr<WebCore::Geolocation> coreObject;
#endif // ENABLE(GEOLOCATION)
} WebKitDOMGeolocationPrivate;

#if ENABLE(GEOLOCATION)

namespace WebKit {

WebKitDOMGeolocation* kit(WebCore::Geolocation* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_GEOLOCATION(ret);

    return wrapGeolocation(obj);
}

WebCore::Geolocation* core(WebKitDOMGeolocation* request)
{
    return request ? static_cast<WebCore::Geolocation*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMGeolocation* wrapGeolocation(WebCore::Geolocation* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_GEOLOCATION(g_object_new(WEBKIT_TYPE_DOM_GEOLOCATION, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(GEOLOCATION)

G_DEFINE_TYPE(WebKitDOMGeolocation, webkit_dom_geolocation, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_geolocation_finalize(GObject* object)
{
    WebKitDOMGeolocationPrivate* priv = WEBKIT_DOM_GEOLOCATION_GET_PRIVATE(object);
#if ENABLE(GEOLOCATION)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(GEOLOCATION)
    priv->~WebKitDOMGeolocationPrivate();
    G_OBJECT_CLASS(webkit_dom_geolocation_parent_class)->finalize(object);
}

static GObject* webkit_dom_geolocation_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_geolocation_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(GEOLOCATION)
    WebKitDOMGeolocationPrivate* priv = WEBKIT_DOM_GEOLOCATION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Geolocation*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(GEOLOCATION)
    return object;
}

static void webkit_dom_geolocation_class_init(WebKitDOMGeolocationClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMGeolocationPrivate));
    gobjectClass->constructor = webkit_dom_geolocation_constructor;
    gobjectClass->finalize = webkit_dom_geolocation_finalize;
}

static void webkit_dom_geolocation_init(WebKitDOMGeolocation* request)
{
    WebKitDOMGeolocationPrivate* priv = WEBKIT_DOM_GEOLOCATION_GET_PRIVATE(request);
    new (priv) WebKitDOMGeolocationPrivate();
}

void
webkit_dom_geolocation_clear_watch(WebKitDOMGeolocation* self, glong watchID)
{
#if ENABLE(GEOLOCATION)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_GEOLOCATION(self));
    WebCore::Geolocation* item = WebKit::core(self);
    item->clearWatch(watchID);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Geolocation")
#endif /* ENABLE(GEOLOCATION) */
}

