/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLDListElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLDListElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLDListElement* kit(WebCore::HTMLDListElement* obj)
{
    return WEBKIT_DOM_HTMLD_LIST_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLDListElement* core(WebKitDOMHTMLDListElement* request)
{
    return request ? static_cast<WebCore::HTMLDListElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLDListElement* wrapHTMLDListElement(WebCore::HTMLDListElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTMLD_LIST_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTMLD_LIST_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLDListElement, webkit_dom_htmld_list_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_COMPACT,
};

static void webkit_dom_htmld_list_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLDListElement* self = WEBKIT_DOM_HTMLD_LIST_ELEMENT(object);
    WebCore::HTMLDListElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COMPACT: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::compactAttr, (g_value_get_boolean(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmld_list_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLDListElement* self = WEBKIT_DOM_HTMLD_LIST_ELEMENT(object);
    WebCore::HTMLDListElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COMPACT: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::compactAttr));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmld_list_element_class_init(WebKitDOMHTMLDListElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_htmld_list_element_set_property;
    gobjectClass->get_property = webkit_dom_htmld_list_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_COMPACT,
                                    g_param_spec_boolean("compact", /* name */
                                                           "htmld_list_element_compact", /* short description */
                                                           "read-write  gboolean HTMLDListElement.compact", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_htmld_list_element_init(WebKitDOMHTMLDListElement* request)
{
}

gboolean
webkit_dom_htmld_list_element_get_compact(WebKitDOMHTMLDListElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLD_LIST_ELEMENT(self), FALSE);
    WebCore::HTMLDListElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::compactAttr);
    return result;
}

void
webkit_dom_htmld_list_element_set_compact(WebKitDOMHTMLDListElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLD_LIST_ELEMENT(self));
    WebCore::HTMLDListElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::compactAttr, value);
}

