/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMSettableTokenListPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLElement* kit(WebCore::HTMLElement* obj)
{
    return WEBKIT_DOM_HTML_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLElement* core(WebKitDOMHTMLElement* request)
{
    return request ? static_cast<WebCore::HTMLElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLElement* wrapHTMLElement(WebCore::HTMLElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLElement, webkit_dom_html_element, WEBKIT_TYPE_DOM_ELEMENT)

enum {
    PROP_0,
    PROP_ID,
    PROP_TITLE,
    PROP_LANG,
    PROP_TRANSLATE,
    PROP_DIR,
    PROP_TAB_INDEX,
    PROP_DRAGGABLE,
    PROP_WEBKITDROPZONE,
    PROP_HIDDEN,
    PROP_ACCESS_KEY,
    PROP_INNER_HTML,
    PROP_INNER_TEXT,
    PROP_OUTER_HTML,
    PROP_OUTER_TEXT,
    PROP_CHILDREN,
    PROP_CONTENT_EDITABLE,
    PROP_IS_CONTENT_EDITABLE,
    PROP_SPELLCHECK,
    PROP_ITEM_SCOPE,
    PROP_ITEM_TYPE,
    PROP_ITEM_ID,
    PROP_ITEM_REF,
    PROP_ITEM_PROP,
};

static void webkit_dom_html_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLElement* self = WEBKIT_DOM_HTML_ELEMENT(object);
    WebCore::HTMLElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ID: {
        coreSelf->setAttribute(WebCore::HTMLNames::idAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TITLE: {
        coreSelf->setAttribute(WebCore::HTMLNames::titleAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_LANG: {
        coreSelf->setAttribute(WebCore::HTMLNames::langAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TRANSLATE: {
        coreSelf->setTranslate((g_value_get_boolean(value)));
        break;
    }
    case PROP_DIR: {
        coreSelf->setAttribute(WebCore::HTMLNames::dirAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TAB_INDEX: {
        coreSelf->setTabIndex((g_value_get_long(value)));
        break;
    }
    case PROP_DRAGGABLE: {
        coreSelf->setDraggable((g_value_get_boolean(value)));
        break;
    }
    case PROP_WEBKITDROPZONE: {
        coreSelf->setAttribute(WebCore::HTMLNames::webkitdropzoneAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HIDDEN: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_ACCESS_KEY: {
        coreSelf->setAttribute(WebCore::HTMLNames::accesskeyAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_INNER_HTML: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setInnerHTML(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_INNER_TEXT: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setInnerText(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_OUTER_HTML: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setOuterHTML(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_OUTER_TEXT: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setOuterText(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_CONTENT_EDITABLE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setContentEditable(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_SPELLCHECK: {
        coreSelf->setSpellcheck((g_value_get_boolean(value)));
        break;
    }
    case PROP_ITEM_SCOPE: {
#if ENABLE(MICRODATA)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::itemscopeAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_ITEM_ID: {
#if ENABLE(MICRODATA)
        coreSelf->setAttribute(WebCore::HTMLNames::itemidAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLElement* self = WEBKIT_DOM_HTML_ELEMENT(object);
    WebCore::HTMLElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ID: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getIdAttribute()));
        break;
    }
    case PROP_TITLE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::titleAttr)));
        break;
    }
    case PROP_LANG: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::langAttr)));
        break;
    }
    case PROP_TRANSLATE: {
        g_value_set_boolean(value, coreSelf->translate());
        break;
    }
    case PROP_DIR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::dirAttr)));
        break;
    }
    case PROP_TAB_INDEX: {
        g_value_set_long(value, coreSelf->tabIndex());
        break;
    }
    case PROP_DRAGGABLE: {
        g_value_set_boolean(value, coreSelf->draggable());
        break;
    }
    case PROP_WEBKITDROPZONE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::webkitdropzoneAttr)));
        break;
    }
    case PROP_HIDDEN: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::hiddenAttr));
        break;
    }
    case PROP_ACCESS_KEY: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::accesskeyAttr)));
        break;
    }
    case PROP_INNER_HTML: {
        g_value_take_string(value, convertToUTF8String(coreSelf->innerHTML()));
        break;
    }
    case PROP_INNER_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->innerText()));
        break;
    }
    case PROP_OUTER_HTML: {
        g_value_take_string(value, convertToUTF8String(coreSelf->outerHTML()));
        break;
    }
    case PROP_OUTER_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->outerText()));
        break;
    }
    case PROP_CHILDREN: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->children();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONTENT_EDITABLE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->contentEditable()));
        break;
    }
    case PROP_IS_CONTENT_EDITABLE: {
        g_value_set_boolean(value, coreSelf->isContentEditable());
        break;
    }
    case PROP_SPELLCHECK: {
        g_value_set_boolean(value, coreSelf->spellcheck());
        break;
    }
    case PROP_ITEM_SCOPE: {
#if ENABLE(MICRODATA)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::itemscopeAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_ITEM_TYPE: {
#if ENABLE(MICRODATA)
        RefPtr<WebCore::DOMSettableTokenList> ptr = coreSelf->itemType();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_ITEM_ID: {
#if ENABLE(MICRODATA)
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::itemidAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_ITEM_REF: {
#if ENABLE(MICRODATA)
        RefPtr<WebCore::DOMSettableTokenList> ptr = coreSelf->itemRef();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_ITEM_PROP: {
#if ENABLE(MICRODATA)
        RefPtr<WebCore::DOMSettableTokenList> ptr = coreSelf->itemProp();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_element_class_init(WebKitDOMHTMLElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_element_set_property;
    gobjectClass->get_property = webkit_dom_html_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ID,
                                    g_param_spec_string("id", /* name */
                                                           "html_element_id", /* short description */
                                                           "read-write  gchar* HTMLElement.id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TITLE,
                                    g_param_spec_string("title", /* name */
                                                           "html_element_title", /* short description */
                                                           "read-write  gchar* HTMLElement.title", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LANG,
                                    g_param_spec_string("lang", /* name */
                                                           "html_element_lang", /* short description */
                                                           "read-write  gchar* HTMLElement.lang", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TRANSLATE,
                                    g_param_spec_boolean("translate", /* name */
                                                           "html_element_translate", /* short description */
                                                           "read-write  gboolean HTMLElement.translate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DIR,
                                    g_param_spec_string("dir", /* name */
                                                           "html_element_dir", /* short description */
                                                           "read-write  gchar* HTMLElement.dir", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TAB_INDEX,
                                    g_param_spec_long("tab-index", /* name */
                                                           "html_element_tab-index", /* short description */
                                                           "read-write  glong HTMLElement.tab-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DRAGGABLE,
                                    g_param_spec_boolean("draggable", /* name */
                                                           "html_element_draggable", /* short description */
                                                           "read-write  gboolean HTMLElement.draggable", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKITDROPZONE,
                                    g_param_spec_string("webkitdropzone", /* name */
                                                           "html_element_webkitdropzone", /* short description */
                                                           "read-write  gchar* HTMLElement.webkitdropzone", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HIDDEN,
                                    g_param_spec_boolean("hidden", /* name */
                                                           "html_element_hidden", /* short description */
                                                           "read-write  gboolean HTMLElement.hidden", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ACCESS_KEY,
                                    g_param_spec_string("access-key", /* name */
                                                           "html_element_access-key", /* short description */
                                                           "read-write  gchar* HTMLElement.access-key", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INNER_HTML,
                                    g_param_spec_string("inner-html", /* name */
                                                           "html_element_inner-html", /* short description */
                                                           "read-write  gchar* HTMLElement.inner-html", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INNER_TEXT,
                                    g_param_spec_string("inner-text", /* name */
                                                           "html_element_inner-text", /* short description */
                                                           "read-write  gchar* HTMLElement.inner-text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OUTER_HTML,
                                    g_param_spec_string("outer-html", /* name */
                                                           "html_element_outer-html", /* short description */
                                                           "read-write  gchar* HTMLElement.outer-html", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OUTER_TEXT,
                                    g_param_spec_string("outer-text", /* name */
                                                           "html_element_outer-text", /* short description */
                                                           "read-write  gchar* HTMLElement.outer-text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHILDREN,
                                    g_param_spec_object("children", /* name */
                                                           "html_element_children", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLElement.children", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_EDITABLE,
                                    g_param_spec_string("content-editable", /* name */
                                                           "html_element_content-editable", /* short description */
                                                           "read-write  gchar* HTMLElement.content-editable", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IS_CONTENT_EDITABLE,
                                    g_param_spec_boolean("is-content-editable", /* name */
                                                           "html_element_is-content-editable", /* short description */
                                                           "read-only  gboolean HTMLElement.is-content-editable", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SPELLCHECK,
                                    g_param_spec_boolean("spellcheck", /* name */
                                                           "html_element_spellcheck", /* short description */
                                                           "read-write  gboolean HTMLElement.spellcheck", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ITEM_SCOPE,
                                    g_param_spec_boolean("item-scope", /* name */
                                                           "html_element_item-scope", /* short description */
                                                           "read-write  gboolean HTMLElement.item-scope", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ITEM_TYPE,
                                    g_param_spec_object("item-type", /* name */
                                                           "html_element_item-type", /* short description */
                                                           "read-only  WebKitDOMDOMSettableTokenList* HTMLElement.item-type", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_SETTABLE_TOKEN_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ITEM_ID,
                                    g_param_spec_string("item-id", /* name */
                                                           "html_element_item-id", /* short description */
                                                           "read-write  gchar* HTMLElement.item-id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ITEM_REF,
                                    g_param_spec_object("item-ref", /* name */
                                                           "html_element_item-ref", /* short description */
                                                           "read-only  WebKitDOMDOMSettableTokenList* HTMLElement.item-ref", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_SETTABLE_TOKEN_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ITEM_PROP,
                                    g_param_spec_object("item-prop", /* name */
                                                           "html_element_item-prop", /* short description */
                                                           "read-only  WebKitDOMDOMSettableTokenList* HTMLElement.item-prop", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_SETTABLE_TOKEN_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_element_init(WebKitDOMHTMLElement* request)
{
}

WebKitDOMElement*
webkit_dom_html_element_insert_adjacent_element(WebKitDOMHTMLElement* self, const gchar* where, WebKitDOMElement* element, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    g_return_val_if_fail(where, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(element), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedWhere = WTF::String::fromUTF8(where);
    WebCore::Element* convertedElement = WebKit::core(element);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->insertAdjacentElement(convertedWhere, convertedElement, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_element_insert_adjacent_html(WebKitDOMHTMLElement* self, const gchar* where, const gchar* html, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(where);
    g_return_if_fail(html);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedWhere = WTF::String::fromUTF8(where);
    WTF::String convertedHtml = WTF::String::fromUTF8(html);
    WebCore::ExceptionCode ec = 0;
    item->insertAdjacentHTML(convertedWhere, convertedHtml, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_element_insert_adjacent_text(WebKitDOMHTMLElement* self, const gchar* where, const gchar* text, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(where);
    g_return_if_fail(text);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedWhere = WTF::String::fromUTF8(where);
    WTF::String convertedText = WTF::String::fromUTF8(text);
    WebCore::ExceptionCode ec = 0;
    item->insertAdjacentText(convertedWhere, convertedText, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_element_click(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->click();
}

gchar*
webkit_dom_html_element_get_id(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getIdAttribute());
    return result;
}

void
webkit_dom_html_element_set_id(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::idAttr, convertedValue);
}

gchar*
webkit_dom_html_element_get_title(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::titleAttr));
    return result;
}

void
webkit_dom_html_element_set_title(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::titleAttr, convertedValue);
}

gchar*
webkit_dom_html_element_get_lang(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::langAttr));
    return result;
}

void
webkit_dom_html_element_set_lang(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::langAttr, convertedValue);
}

gboolean
webkit_dom_html_element_get_translate(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->translate();
    return result;
}

void
webkit_dom_html_element_set_translate(WebKitDOMHTMLElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setTranslate(value);
}

gchar*
webkit_dom_html_element_get_dir(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::dirAttr));
    return result;
}

void
webkit_dom_html_element_set_dir(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::dirAttr, convertedValue);
}

glong
webkit_dom_html_element_get_tab_index(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    glong result = item->tabIndex();
    return result;
}

void
webkit_dom_html_element_set_tab_index(WebKitDOMHTMLElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setTabIndex(value);
}

gboolean
webkit_dom_html_element_get_draggable(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->draggable();
    return result;
}

void
webkit_dom_html_element_set_draggable(WebKitDOMHTMLElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setDraggable(value);
}

gchar*
webkit_dom_html_element_get_webkitdropzone(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::webkitdropzoneAttr));
    return result;
}

void
webkit_dom_html_element_set_webkitdropzone(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::webkitdropzoneAttr, convertedValue);
}

gboolean
webkit_dom_html_element_get_hidden(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::hiddenAttr);
    return result;
}

void
webkit_dom_html_element_set_hidden(WebKitDOMHTMLElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, value);
}

gchar*
webkit_dom_html_element_get_access_key(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::accesskeyAttr));
    return result;
}

void
webkit_dom_html_element_set_access_key(WebKitDOMHTMLElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::accesskeyAttr, convertedValue);
}

gchar*
webkit_dom_html_element_get_inner_html(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->innerHTML());
    return result;
}

void
webkit_dom_html_element_set_inner_html(WebKitDOMHTMLElement* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setInnerHTML(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_element_get_inner_text(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->innerText());
    return result;
}

void
webkit_dom_html_element_set_inner_text(WebKitDOMHTMLElement* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setInnerText(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_element_get_outer_html(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->outerHTML());
    return result;
}

void
webkit_dom_html_element_set_outer_html(WebKitDOMHTMLElement* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setOuterHTML(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_element_get_outer_text(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->outerText());
    return result;
}

void
webkit_dom_html_element_set_outer_text(WebKitDOMHTMLElement* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setOuterText(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLCollection*
webkit_dom_html_element_get_children(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->children());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_element_get_content_editable(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->contentEditable());
    return result;
}

void
webkit_dom_html_element_set_content_editable(WebKitDOMHTMLElement* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setContentEditable(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gboolean
webkit_dom_html_element_get_is_content_editable(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->isContentEditable();
    return result;
}

gboolean
webkit_dom_html_element_get_spellcheck(WebKitDOMHTMLElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->spellcheck();
    return result;
}

void
webkit_dom_html_element_set_spellcheck(WebKitDOMHTMLElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setSpellcheck(value);
}

gboolean
webkit_dom_html_element_get_item_scope(WebKitDOMHTMLElement* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), FALSE);
    WebCore::HTMLElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::itemscopeAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return static_cast<gboolean>(0);
#endif /* ENABLE(MICRODATA) */
}

void
webkit_dom_html_element_set_item_scope(WebKitDOMHTMLElement* self, gboolean value)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    WebCore::HTMLElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::itemscopeAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
}

WebKitDOMDOMSettableTokenList*
webkit_dom_html_element_get_item_type(WebKitDOMHTMLElement* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    RefPtr<WebCore::DOMSettableTokenList> gobjectResult = WTF::getPtr(item->itemType());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

gchar*
webkit_dom_html_element_get_item_id(WebKitDOMHTMLElement* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::itemidAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

void
webkit_dom_html_element_set_item_id(WebKitDOMHTMLElement* self, const gchar* value)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::itemidAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
}

WebKitDOMDOMSettableTokenList*
webkit_dom_html_element_get_item_ref(WebKitDOMHTMLElement* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    RefPtr<WebCore::DOMSettableTokenList> gobjectResult = WTF::getPtr(item->itemRef());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

WebKitDOMDOMSettableTokenList*
webkit_dom_html_element_get_item_prop(WebKitDOMHTMLElement* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(self), 0);
    WebCore::HTMLElement* item = WebKit::core(self);
    RefPtr<WebCore::DOMSettableTokenList> gobjectResult = WTF::getPtr(item->itemProp());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

