/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLEmbedElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLEmbedElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLEmbedElement* kit(WebCore::HTMLEmbedElement* obj)
{
    return WEBKIT_DOM_HTML_EMBED_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLEmbedElement* core(WebKitDOMHTMLEmbedElement* request)
{
    return request ? static_cast<WebCore::HTMLEmbedElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLEmbedElement* wrapHTMLEmbedElement(WebCore::HTMLEmbedElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_EMBED_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_EMBED_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLEmbedElement, webkit_dom_html_embed_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALIGN,
    PROP_HEIGHT,
    PROP_NAME,
    PROP_SRC,
    PROP_TYPE,
    PROP_WIDTH,
};

static void webkit_dom_html_embed_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLEmbedElement* self = WEBKIT_DOM_HTML_EMBED_ELEMENT(object);
    WebCore::HTMLEmbedElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::heightAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::widthAttr, (g_value_get_long(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_embed_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLEmbedElement* self = WEBKIT_DOM_HTML_EMBED_ELEMENT(object);
    WebCore::HTMLEmbedElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::heightAttr));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::widthAttr));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_embed_element_class_init(WebKitDOMHTMLEmbedElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_embed_element_set_property;
    gobjectClass->get_property = webkit_dom_html_embed_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_embed_element_align", /* short description */
                                                           "read-write  gchar* HTMLEmbedElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_long("height", /* name */
                                                           "html_embed_element_height", /* short description */
                                                           "read-write  glong HTMLEmbedElement.height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_embed_element_name", /* short description */
                                                           "read-write  gchar* HTMLEmbedElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_embed_element_src", /* short description */
                                                           "read-write  gchar* HTMLEmbedElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_embed_element_type", /* short description */
                                                           "read-write  gchar* HTMLEmbedElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_embed_element_width", /* short description */
                                                           "read-write  glong HTMLEmbedElement.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_embed_element_init(WebKitDOMHTMLEmbedElement* request)
{
}

gchar*
webkit_dom_html_embed_element_get_align(WebKitDOMHTMLEmbedElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self), 0);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_embed_element_set_align(WebKitDOMHTMLEmbedElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

glong
webkit_dom_html_embed_element_get_height(WebKitDOMHTMLEmbedElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self), 0);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::heightAttr);
    return result;
}

void
webkit_dom_html_embed_element_set_height(WebKitDOMHTMLEmbedElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self));
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::heightAttr, value);
}

gchar*
webkit_dom_html_embed_element_get_name(WebKitDOMHTMLEmbedElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self), 0);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_embed_element_set_name(WebKitDOMHTMLEmbedElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_embed_element_get_src(WebKitDOMHTMLEmbedElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self), 0);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_embed_element_set_src(WebKitDOMHTMLEmbedElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

glong
webkit_dom_html_embed_element_get_width(WebKitDOMHTMLEmbedElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self), 0);
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::widthAttr);
    return result;
}

void
webkit_dom_html_embed_element_set_width(WebKitDOMHTMLEmbedElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_EMBED_ELEMENT(self));
    WebCore::HTMLEmbedElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::widthAttr, value);
}

