/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLLabelElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLLabelElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLLabelElement* kit(WebCore::HTMLLabelElement* obj)
{
    return WEBKIT_DOM_HTML_LABEL_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLLabelElement* core(WebKitDOMHTMLLabelElement* request)
{
    return request ? static_cast<WebCore::HTMLLabelElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLLabelElement* wrapHTMLLabelElement(WebCore::HTMLLabelElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_LABEL_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_LABEL_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLLabelElement, webkit_dom_html_label_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_FORM,
    PROP_HTML_FOR,
    PROP_CONTROL,
};

static void webkit_dom_html_label_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLabelElement* self = WEBKIT_DOM_HTML_LABEL_ELEMENT(object);
    WebCore::HTMLLabelElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_HTML_FOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::forAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_label_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLabelElement* self = WEBKIT_DOM_HTML_LABEL_ELEMENT(object);
    WebCore::HTMLLabelElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_HTML_FOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::forAttr)));
        break;
    }
    case PROP_CONTROL: {
        RefPtr<WebCore::HTMLElement> ptr = coreSelf->control();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_label_element_class_init(WebKitDOMHTMLLabelElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_label_element_set_property;
    gobjectClass->get_property = webkit_dom_html_label_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_label_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLLabelElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HTML_FOR,
                                    g_param_spec_string("html-for", /* name */
                                                           "html_label_element_html-for", /* short description */
                                                           "read-write  gchar* HTMLLabelElement.html-for", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTROL,
                                    g_param_spec_object("control", /* name */
                                                           "html_label_element_control", /* short description */
                                                           "read-only  WebKitDOMHTMLElement* HTMLLabelElement.control", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_label_element_init(WebKitDOMHTMLLabelElement* request)
{
}

WebKitDOMHTMLFormElement*
webkit_dom_html_label_element_get_form(WebKitDOMHTMLLabelElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LABEL_ELEMENT(self), 0);
    WebCore::HTMLLabelElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_label_element_get_html_for(WebKitDOMHTMLLabelElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LABEL_ELEMENT(self), 0);
    WebCore::HTMLLabelElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::forAttr));
    return result;
}

void
webkit_dom_html_label_element_set_html_for(WebKitDOMHTMLLabelElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LABEL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLabelElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::forAttr, convertedValue);
}

WebKitDOMHTMLElement*
webkit_dom_html_label_element_get_control(WebKitDOMHTMLLabelElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LABEL_ELEMENT(self), 0);
    WebCore::HTMLLabelElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->control());
    return WebKit::kit(gobjectResult.get());
}

