/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLMediaElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLMediaElementPrivate.h"
#include "WebKitDOMMediaErrorPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTimeRangesPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(VIDEO)

namespace WebKit {

WebKitDOMHTMLMediaElement* kit(WebCore::HTMLMediaElement* obj)
{
    return WEBKIT_DOM_HTML_MEDIA_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLMediaElement* core(WebKitDOMHTMLMediaElement* request)
{
    return request ? static_cast<WebCore::HTMLMediaElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLMediaElement* wrapHTMLMediaElement(WebCore::HTMLMediaElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_MEDIA_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_MEDIA_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO)

G_DEFINE_TYPE(WebKitDOMHTMLMediaElement, webkit_dom_html_media_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ERROR,
    PROP_SRC,
    PROP_CURRENT_SRC,
    PROP_NETWORK_STATE,
    PROP_PRELOAD,
    PROP_BUFFERED,
    PROP_READY_STATE,
    PROP_SEEKING,
    PROP_CURRENT_TIME,
    PROP_INITIAL_TIME,
    PROP_START_TIME,
    PROP_DURATION,
    PROP_PAUSED,
    PROP_DEFAULT_PLAYBACK_RATE,
    PROP_PLAYBACK_RATE,
    PROP_PLAYED,
    PROP_SEEKABLE,
    PROP_ENDED,
    PROP_AUTOPLAY,
    PROP_LOOP,
    PROP_CONTROLS,
    PROP_VOLUME,
    PROP_MUTED,
    PROP_DEFAULT_MUTED,
    PROP_WEBKIT_PRESERVES_PITCH,
    PROP_WEBKIT_HAS_CLOSED_CAPTIONS,
    PROP_WEBKIT_CLOSED_CAPTIONS_VISIBLE,
    PROP_WEBKIT_AUDIO_DECODED_BYTE_COUNT,
    PROP_WEBKIT_VIDEO_DECODED_BYTE_COUNT,
    PROP_MEDIA_GROUP,
};

static void webkit_dom_html_media_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMHTMLMediaElement* self = WEBKIT_DOM_HTML_MEDIA_ELEMENT(object);
    WebCore::HTMLMediaElement* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_SRC: {
#if ENABLE(VIDEO)
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PRELOAD: {
#if ENABLE(VIDEO)
        coreSelf->setPreload(WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_CURRENT_TIME: {
#if ENABLE(VIDEO)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setCurrentTime((g_value_get_float(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_DEFAULT_PLAYBACK_RATE: {
#if ENABLE(VIDEO)
        coreSelf->setDefaultPlaybackRate((g_value_get_float(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PLAYBACK_RATE: {
#if ENABLE(VIDEO)
        coreSelf->setPlaybackRate((g_value_get_float(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_AUTOPLAY: {
#if ENABLE(VIDEO)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_LOOP: {
#if ENABLE(VIDEO)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::loopAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_CONTROLS: {
#if ENABLE(VIDEO)
        coreSelf->setControls((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_VOLUME: {
#if ENABLE(VIDEO)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setVolume((g_value_get_float(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_MUTED: {
#if ENABLE(VIDEO)
        coreSelf->setMuted((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_DEFAULT_MUTED: {
#if ENABLE(VIDEO)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::mutedAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_PRESERVES_PITCH: {
#if ENABLE(VIDEO)
        coreSelf->setWebkitPreservesPitch((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_CLOSED_CAPTIONS_VISIBLE: {
#if ENABLE(VIDEO)
        coreSelf->setWebkitClosedCaptionsVisible((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_MEDIA_GROUP: {
#if ENABLE(VIDEO)
        coreSelf->setAttribute(WebCore::HTMLNames::mediagroupAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_media_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMHTMLMediaElement* self = WEBKIT_DOM_HTML_MEDIA_ELEMENT(object);
    WebCore::HTMLMediaElement* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_ERROR: {
#if ENABLE(VIDEO)
        RefPtr<WebCore::MediaError> ptr = coreSelf->error();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_SRC: {
#if ENABLE(VIDEO)
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_CURRENT_SRC: {
#if ENABLE(VIDEO)
        g_value_take_string(value, convertToUTF8String(coreSelf->currentSrc()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_NETWORK_STATE: {
#if ENABLE(VIDEO)
        g_value_set_uint(value, coreSelf->networkState());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PRELOAD: {
#if ENABLE(VIDEO)
        g_value_take_string(value, convertToUTF8String(coreSelf->preload()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_BUFFERED: {
#if ENABLE(VIDEO)
        RefPtr<WebCore::TimeRanges> ptr = coreSelf->buffered();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_READY_STATE: {
#if ENABLE(VIDEO)
        g_value_set_uint(value, coreSelf->readyState());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_SEEKING: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->seeking());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_CURRENT_TIME: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->currentTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_INITIAL_TIME: {
#if ENABLE(VIDEO)
        g_value_set_double(value, coreSelf->initialTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_START_TIME: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->startTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_DURATION: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->duration());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PAUSED: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->paused());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_DEFAULT_PLAYBACK_RATE: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->defaultPlaybackRate());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PLAYBACK_RATE: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->playbackRate());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_PLAYED: {
#if ENABLE(VIDEO)
        RefPtr<WebCore::TimeRanges> ptr = coreSelf->played();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_SEEKABLE: {
#if ENABLE(VIDEO)
        RefPtr<WebCore::TimeRanges> ptr = coreSelf->seekable();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_ENDED: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->ended());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_AUTOPLAY: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autoplayAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_LOOP: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::loopAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_CONTROLS: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->controls());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_VOLUME: {
#if ENABLE(VIDEO)
        g_value_set_float(value, coreSelf->volume());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_MUTED: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->muted());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_DEFAULT_MUTED: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::mutedAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_PRESERVES_PITCH: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->webkitPreservesPitch());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_HAS_CLOSED_CAPTIONS: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->webkitHasClosedCaptions());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_CLOSED_CAPTIONS_VISIBLE: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->webkitClosedCaptionsVisible());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_AUDIO_DECODED_BYTE_COUNT: {
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
        g_value_set_ulong(value, coreSelf->webkitAudioDecodedByteCount());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_VIDEO_DECODED_BYTE_COUNT: {
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
        g_value_set_ulong(value, coreSelf->webkitVideoDecodedByteCount());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_MEDIA_GROUP: {
#if ENABLE(VIDEO)
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::mediagroupAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_media_element_class_init(WebKitDOMHTMLMediaElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_media_element_set_property;
    gobjectClass->get_property = webkit_dom_html_media_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ERROR,
                                    g_param_spec_object("error", /* name */
                                                           "html_media_element_error", /* short description */
                                                           "read-only  WebKitDOMMediaError* HTMLMediaElement.error", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_MEDIA_ERROR, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_media_element_src", /* short description */
                                                           "read-write  gchar* HTMLMediaElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CURRENT_SRC,
                                    g_param_spec_string("current-src", /* name */
                                                           "html_media_element_current-src", /* short description */
                                                           "read-only  gchar* HTMLMediaElement.current-src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NETWORK_STATE,
                                    g_param_spec_uint("network-state", /* name */
                                                           "html_media_element_network-state", /* short description */
                                                           "read-only  gushort HTMLMediaElement.network-state", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PRELOAD,
                                    g_param_spec_string("preload", /* name */
                                                           "html_media_element_preload", /* short description */
                                                           "read-write  gchar* HTMLMediaElement.preload", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BUFFERED,
                                    g_param_spec_object("buffered", /* name */
                                                           "html_media_element_buffered", /* short description */
                                                           "read-only  WebKitDOMTimeRanges* HTMLMediaElement.buffered", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TIME_RANGES, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_READY_STATE,
                                    g_param_spec_uint("ready-state", /* name */
                                                           "html_media_element_ready-state", /* short description */
                                                           "read-only  gushort HTMLMediaElement.ready-state", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SEEKING,
                                    g_param_spec_boolean("seeking", /* name */
                                                           "html_media_element_seeking", /* short description */
                                                           "read-only  gboolean HTMLMediaElement.seeking", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CURRENT_TIME,
                                    g_param_spec_float("current-time", /* name */
                                                           "html_media_element_current-time", /* short description */
                                                           "read-write  gfloat HTMLMediaElement.current-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INITIAL_TIME,
                                    g_param_spec_double("initial-time", /* name */
                                                           "html_media_element_initial-time", /* short description */
                                                           "read-only  gdouble HTMLMediaElement.initial-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_START_TIME,
                                    g_param_spec_float("start-time", /* name */
                                                           "html_media_element_start-time", /* short description */
                                                           "read-only  gfloat HTMLMediaElement.start-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DURATION,
                                    g_param_spec_float("duration", /* name */
                                                           "html_media_element_duration", /* short description */
                                                           "read-only  gfloat HTMLMediaElement.duration", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAUSED,
                                    g_param_spec_boolean("paused", /* name */
                                                           "html_media_element_paused", /* short description */
                                                           "read-only  gboolean HTMLMediaElement.paused", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_PLAYBACK_RATE,
                                    g_param_spec_float("default-playback-rate", /* name */
                                                           "html_media_element_default-playback-rate", /* short description */
                                                           "read-write  gfloat HTMLMediaElement.default-playback-rate", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLAYBACK_RATE,
                                    g_param_spec_float("playback-rate", /* name */
                                                           "html_media_element_playback-rate", /* short description */
                                                           "read-write  gfloat HTMLMediaElement.playback-rate", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLAYED,
                                    g_param_spec_object("played", /* name */
                                                           "html_media_element_played", /* short description */
                                                           "read-only  WebKitDOMTimeRanges* HTMLMediaElement.played", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TIME_RANGES, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SEEKABLE,
                                    g_param_spec_object("seekable", /* name */
                                                           "html_media_element_seekable", /* short description */
                                                           "read-only  WebKitDOMTimeRanges* HTMLMediaElement.seekable", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TIME_RANGES, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENDED,
                                    g_param_spec_boolean("ended", /* name */
                                                           "html_media_element_ended", /* short description */
                                                           "read-only  gboolean HTMLMediaElement.ended", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOPLAY,
                                    g_param_spec_boolean("autoplay", /* name */
                                                           "html_media_element_autoplay", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.autoplay", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOOP,
                                    g_param_spec_boolean("loop", /* name */
                                                           "html_media_element_loop", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.loop", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTROLS,
                                    g_param_spec_boolean("controls", /* name */
                                                           "html_media_element_controls", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.controls", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VOLUME,
                                    g_param_spec_float("volume", /* name */
                                                           "html_media_element_volume", /* short description */
                                                           "read-write  gfloat HTMLMediaElement.volume", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MUTED,
                                    g_param_spec_boolean("muted", /* name */
                                                           "html_media_element_muted", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.muted", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_MUTED,
                                    g_param_spec_boolean("default-muted", /* name */
                                                           "html_media_element_default-muted", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.default-muted", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_PRESERVES_PITCH,
                                    g_param_spec_boolean("webkit-preserves-pitch", /* name */
                                                           "html_media_element_webkit-preserves-pitch", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.webkit-preserves-pitch", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_HAS_CLOSED_CAPTIONS,
                                    g_param_spec_boolean("webkit-has-closed-captions", /* name */
                                                           "html_media_element_webkit-has-closed-captions", /* short description */
                                                           "read-only  gboolean HTMLMediaElement.webkit-has-closed-captions", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_CLOSED_CAPTIONS_VISIBLE,
                                    g_param_spec_boolean("webkit-closed-captions-visible", /* name */
                                                           "html_media_element_webkit-closed-captions-visible", /* short description */
                                                           "read-write  gboolean HTMLMediaElement.webkit-closed-captions-visible", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_AUDIO_DECODED_BYTE_COUNT,
                                    g_param_spec_ulong("webkit-audio-decoded-byte-count", /* name */
                                                           "html_media_element_webkit-audio-decoded-byte-count", /* short description */
                                                           "read-only  gulong HTMLMediaElement.webkit-audio-decoded-byte-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_VIDEO_DECODED_BYTE_COUNT,
                                    g_param_spec_ulong("webkit-video-decoded-byte-count", /* name */
                                                           "html_media_element_webkit-video-decoded-byte-count", /* short description */
                                                           "read-only  gulong HTMLMediaElement.webkit-video-decoded-byte-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MEDIA_GROUP,
                                    g_param_spec_string("media-group", /* name */
                                                           "html_media_element_media-group", /* short description */
                                                           "read-write  gchar* HTMLMediaElement.media-group", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_media_element_init(WebKitDOMHTMLMediaElement* request)
{
}

void
webkit_dom_html_media_element_load(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->load();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_media_element_can_play_type(WebKitDOMHTMLMediaElement* self, const gchar* type)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    g_return_val_if_fail(type, 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WTF::String convertedType = WTF::String::fromUTF8(type);
    gchar* result = convertToUTF8String(item->canPlayType(convertedType));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_play(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->play();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_pause(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->pause();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

WebKitDOMMediaError*
webkit_dom_html_media_element_get_error(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    RefPtr<WebCore::MediaError> gobjectResult = WTF::getPtr(item->error());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_media_element_get_src(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_src(WebKitDOMHTMLMediaElement* self, const gchar* value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_media_element_get_current_src(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->currentSrc());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

gushort
webkit_dom_html_media_element_get_network_state(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gushort result = item->networkState();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gushort>(0);
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_media_element_get_preload(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->preload());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_preload(WebKitDOMHTMLMediaElement* self, const gchar* value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setPreload(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

WebKitDOMTimeRanges*
webkit_dom_html_media_element_get_buffered(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    RefPtr<WebCore::TimeRanges> gobjectResult = WTF::getPtr(item->buffered());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

gushort
webkit_dom_html_media_element_get_ready_state(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gushort result = item->readyState();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gushort>(0);
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_seeking(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->seeking();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_current_time(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->currentTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_current_time(WebKitDOMHTMLMediaElement* self, gfloat value, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setCurrentTime(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gdouble
webkit_dom_html_media_element_get_initial_time(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gdouble result = item->initialTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gdouble>(0);
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_start_time(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->startTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_duration(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->duration();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_paused(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->paused();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_default_playback_rate(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->defaultPlaybackRate();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_default_playback_rate(WebKitDOMHTMLMediaElement* self, gfloat value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setDefaultPlaybackRate(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_playback_rate(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->playbackRate();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_playback_rate(WebKitDOMHTMLMediaElement* self, gfloat value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setPlaybackRate(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

WebKitDOMTimeRanges*
webkit_dom_html_media_element_get_played(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    RefPtr<WebCore::TimeRanges> gobjectResult = WTF::getPtr(item->played());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

WebKitDOMTimeRanges*
webkit_dom_html_media_element_get_seekable(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    RefPtr<WebCore::TimeRanges> gobjectResult = WTF::getPtr(item->seekable());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_ended(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->ended();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_autoplay(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autoplayAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_autoplay(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_loop(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::loopAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_loop(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::loopAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_controls(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->controls();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_controls(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setControls(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_html_media_element_get_volume(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gfloat result = item->volume();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_volume(WebKitDOMHTMLMediaElement* self, gfloat value, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setVolume(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_muted(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->muted();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_muted(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setMuted(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_default_muted(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::mutedAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_default_muted(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::mutedAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_webkit_preserves_pitch(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->webkitPreservesPitch();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_webkit_preserves_pitch(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setWebkitPreservesPitch(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_webkit_has_closed_captions(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->webkitHasClosedCaptions();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_media_element_get_webkit_closed_captions_visible(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), FALSE);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gboolean result = item->webkitClosedCaptionsVisible();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_webkit_closed_captions_visible(WebKitDOMHTMLMediaElement* self, gboolean value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    item->setWebkitClosedCaptionsVisible(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_media_element_get_webkit_audio_decoded_byte_count(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gulong result = item->webkitAudioDecodedByteCount();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
    return static_cast<gulong>(0);
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_media_element_get_webkit_video_decoded_byte_count(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gulong result = item->webkitVideoDecodedByteCount();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
    return static_cast<gulong>(0);
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_media_element_get_media_group(WebKitDOMHTMLMediaElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self), 0);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::mediagroupAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_media_element_set_media_group(WebKitDOMHTMLMediaElement* self, const gchar* value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MEDIA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMediaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::mediagroupAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

