/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLParamElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLParamElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLParamElement* kit(WebCore::HTMLParamElement* obj)
{
    return WEBKIT_DOM_HTML_PARAM_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLParamElement* core(WebKitDOMHTMLParamElement* request)
{
    return request ? static_cast<WebCore::HTMLParamElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLParamElement* wrapHTMLParamElement(WebCore::HTMLParamElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_PARAM_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_PARAM_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLParamElement, webkit_dom_html_param_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_NAME,
    PROP_TYPE,
    PROP_VALUE,
    PROP_VALUE_TYPE,
};

static void webkit_dom_html_param_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLParamElement* self = WEBKIT_DOM_HTML_PARAM_ELEMENT(object);
    WebCore::HTMLParamElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setAttribute(WebCore::HTMLNames::valueAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::valuetypeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_param_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLParamElement* self = WEBKIT_DOM_HTML_PARAM_ELEMENT(object);
    WebCore::HTMLParamElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valueAttr)));
        break;
    }
    case PROP_VALUE_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valuetypeAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_param_element_class_init(WebKitDOMHTMLParamElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_param_element_set_property;
    gobjectClass->get_property = webkit_dom_html_param_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_param_element_name", /* short description */
                                                           "read-write  gchar* HTMLParamElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_param_element_type", /* short description */
                                                           "read-write  gchar* HTMLParamElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_param_element_value", /* short description */
                                                           "read-write  gchar* HTMLParamElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE_TYPE,
                                    g_param_spec_string("value-type", /* name */
                                                           "html_param_element_value-type", /* short description */
                                                           "read-write  gchar* HTMLParamElement.value-type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_param_element_init(WebKitDOMHTMLParamElement* request)
{
}

gchar*
webkit_dom_html_param_element_get_name(WebKitDOMHTMLParamElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self), 0);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_param_element_set_name(WebKitDOMHTMLParamElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_param_element_get_value(WebKitDOMHTMLParamElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self), 0);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valueAttr));
    return result;
}

void
webkit_dom_html_param_element_set_value(WebKitDOMHTMLParamElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valueAttr, convertedValue);
}

gchar*
webkit_dom_html_param_element_get_value_type(WebKitDOMHTMLParamElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self), 0);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valuetypeAttr));
    return result;
}

void
webkit_dom_html_param_element_set_value_type(WebKitDOMHTMLParamElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_PARAM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLParamElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valuetypeAttr, convertedValue);
}

