/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMessagePort.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMMessagePortPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_MESSAGE_PORT_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_MESSAGE_PORT, WebKitDOMMessagePortPrivate)

typedef struct _WebKitDOMMessagePortPrivate {
    RefPtr<WebCore::MessagePort> coreObject;
} WebKitDOMMessagePortPrivate;

namespace WebKit {

WebKitDOMMessagePort* kit(WebCore::MessagePort* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_MESSAGE_PORT(ret);

    return wrapMessagePort(obj);
}

WebCore::MessagePort* core(WebKitDOMMessagePort* request)
{
    return request ? static_cast<WebCore::MessagePort*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMessagePort* wrapMessagePort(WebCore::MessagePort* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MESSAGE_PORT(g_object_new(WEBKIT_TYPE_DOM_MESSAGE_PORT, "core-object", coreObject, NULL));
}

} // namespace WebKit

static void webkit_dom_message_port_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::MessagePort* coreTarget = static_cast<WebCore::MessagePort*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
}

static gboolean webkit_dom_message_port_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
    WebCore::MessagePort* coreTarget = static_cast<WebCore::MessagePort*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
}

static gboolean webkit_dom_message_port_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
    WebCore::MessagePort* coreTarget = static_cast<WebCore::MessagePort*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_message_port_dispatch_event;
    iface->add_event_listener = webkit_dom_message_port_add_event_listener;
    iface->remove_event_listener = webkit_dom_message_port_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMMessagePort, webkit_dom_message_port, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

static void webkit_dom_message_port_finalize(GObject* object)
{
    WebKitDOMMessagePortPrivate* priv = WEBKIT_DOM_MESSAGE_PORT_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMMessagePortPrivate();
    G_OBJECT_CLASS(webkit_dom_message_port_parent_class)->finalize(object);
}

static GObject* webkit_dom_message_port_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_message_port_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMMessagePortPrivate* priv = WEBKIT_DOM_MESSAGE_PORT_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::MessagePort*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_message_port_class_init(WebKitDOMMessagePortClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMMessagePortPrivate));
    gobjectClass->constructor = webkit_dom_message_port_constructor;
    gobjectClass->finalize = webkit_dom_message_port_finalize;
}

static void webkit_dom_message_port_init(WebKitDOMMessagePort* request)
{
    WebKitDOMMessagePortPrivate* priv = WEBKIT_DOM_MESSAGE_PORT_GET_PRIVATE(request);
    new (priv) WebKitDOMMessagePortPrivate();
}

