/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMNodeIterator.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodeFilterPrivate.h"
#include "WebKitDOMNodeIteratorPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_NODE_ITERATOR_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_NODE_ITERATOR, WebKitDOMNodeIteratorPrivate)

typedef struct _WebKitDOMNodeIteratorPrivate {
    RefPtr<WebCore::NodeIterator> coreObject;
} WebKitDOMNodeIteratorPrivate;

namespace WebKit {

WebKitDOMNodeIterator* kit(WebCore::NodeIterator* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_NODE_ITERATOR(ret);

    return wrapNodeIterator(obj);
}

WebCore::NodeIterator* core(WebKitDOMNodeIterator* request)
{
    return request ? static_cast<WebCore::NodeIterator*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMNodeIterator* wrapNodeIterator(WebCore::NodeIterator* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_NODE_ITERATOR(g_object_new(WEBKIT_TYPE_DOM_NODE_ITERATOR, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMNodeIterator, webkit_dom_node_iterator, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ROOT,
    PROP_WHAT_TO_SHOW,
    PROP_FILTER,
    PROP_EXPAND_ENTITY_REFERENCES,
    PROP_REFERENCE_NODE,
    PROP_POINTER_BEFORE_REFERENCE_NODE,
};

static void webkit_dom_node_iterator_finalize(GObject* object)
{
    WebKitDOMNodeIteratorPrivate* priv = WEBKIT_DOM_NODE_ITERATOR_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMNodeIteratorPrivate();
    G_OBJECT_CLASS(webkit_dom_node_iterator_parent_class)->finalize(object);
}

static void webkit_dom_node_iterator_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMNodeIterator* self = WEBKIT_DOM_NODE_ITERATOR(object);
    WebCore::NodeIterator* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ROOT: {
        RefPtr<WebCore::Node> ptr = coreSelf->root();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WHAT_TO_SHOW: {
        g_value_set_ulong(value, coreSelf->whatToShow());
        break;
    }
    case PROP_FILTER: {
        RefPtr<WebCore::NodeFilter> ptr = coreSelf->filter();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_EXPAND_ENTITY_REFERENCES: {
        g_value_set_boolean(value, coreSelf->expandEntityReferences());
        break;
    }
    case PROP_REFERENCE_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->referenceNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_POINTER_BEFORE_REFERENCE_NODE: {
        g_value_set_boolean(value, coreSelf->pointerBeforeReferenceNode());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_node_iterator_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_node_iterator_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMNodeIteratorPrivate* priv = WEBKIT_DOM_NODE_ITERATOR_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::NodeIterator*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_node_iterator_class_init(WebKitDOMNodeIteratorClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMNodeIteratorPrivate));
    gobjectClass->constructor = webkit_dom_node_iterator_constructor;
    gobjectClass->finalize = webkit_dom_node_iterator_finalize;
    gobjectClass->get_property = webkit_dom_node_iterator_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ROOT,
                                    g_param_spec_object("root", /* name */
                                                           "node_iterator_root", /* short description */
                                                           "read-only  WebKitDOMNode* NodeIterator.root", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WHAT_TO_SHOW,
                                    g_param_spec_ulong("what-to-show", /* name */
                                                           "node_iterator_what-to-show", /* short description */
                                                           "read-only  gulong NodeIterator.what-to-show", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FILTER,
                                    g_param_spec_object("filter", /* name */
                                                           "node_iterator_filter", /* short description */
                                                           "read-only  WebKitDOMNodeFilter* NodeIterator.filter", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_FILTER, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EXPAND_ENTITY_REFERENCES,
                                    g_param_spec_boolean("expand-entity-references", /* name */
                                                           "node_iterator_expand-entity-references", /* short description */
                                                           "read-only  gboolean NodeIterator.expand-entity-references", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REFERENCE_NODE,
                                    g_param_spec_object("reference-node", /* name */
                                                           "node_iterator_reference-node", /* short description */
                                                           "read-only  WebKitDOMNode* NodeIterator.reference-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_POINTER_BEFORE_REFERENCE_NODE,
                                    g_param_spec_boolean("pointer-before-reference-node", /* name */
                                                           "node_iterator_pointer-before-reference-node", /* short description */
                                                           "read-only  gboolean NodeIterator.pointer-before-reference-node", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_node_iterator_init(WebKitDOMNodeIterator* request)
{
    WebKitDOMNodeIteratorPrivate* priv = WEBKIT_DOM_NODE_ITERATOR_GET_PRIVATE(request);
    new (priv) WebKitDOMNodeIteratorPrivate();
}

WebKitDOMNode*
webkit_dom_node_iterator_next_node(WebKitDOMNodeIterator* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->nextNode(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_node_iterator_previous_node(WebKitDOMNodeIterator* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->previousNode(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_node_iterator_detach(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self));
    WebCore::NodeIterator* item = WebKit::core(self);
    item->detach();
}

WebKitDOMNode*
webkit_dom_node_iterator_get_root(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->root());
    return WebKit::kit(gobjectResult.get());
}

gulong
webkit_dom_node_iterator_get_what_to_show(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    gulong result = item->whatToShow();
    return result;
}

WebKitDOMNodeFilter*
webkit_dom_node_iterator_get_filter(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    RefPtr<WebCore::NodeFilter> gobjectResult = WTF::getPtr(item->filter());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_node_iterator_get_expand_entity_references(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), FALSE);
    WebCore::NodeIterator* item = WebKit::core(self);
    gboolean result = item->expandEntityReferences();
    return result;
}

WebKitDOMNode*
webkit_dom_node_iterator_get_reference_node(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), 0);
    WebCore::NodeIterator* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->referenceNode());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_node_iterator_get_pointer_before_reference_node(WebKitDOMNodeIterator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_ITERATOR(self), FALSE);
    WebCore::NodeIterator* item = WebKit::core(self);
    gboolean result = item->pointerBeforeReferenceNode();
    return result;
}

