/* timerange.c generated by valac 0.38.8, the Vala compiler
 * generated from timerange.vala, do not modify */

/* timerange.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _ZeitgeistTimeRangePrivate ZeitgeistTimeRangePrivate;
enum  {
	ZEITGEIST_TIME_RANGE_0_PROPERTY,
	ZEITGEIST_TIME_RANGE_START_PROPERTY,
	ZEITGEIST_TIME_RANGE_END_PROPERTY,
	ZEITGEIST_TIME_RANGE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_time_range_properties[ZEITGEIST_TIME_RANGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ZeitgeistTimeRange {
	GObject parent_instance;
	ZeitgeistTimeRangePrivate * priv;
};

struct _ZeitgeistTimeRangeClass {
	GObjectClass parent_class;
};

struct _ZeitgeistTimeRangePrivate {
	gint64 _start;
	gint64 _end;
};

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()

static gpointer zeitgeist_time_range_parent_class = NULL;

GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_TIME_RANGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangePrivate))
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value);
static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value);
ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type);
gint64 zeitgeist_timestamp_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type);
GQuark zeitgeist_data_model_error_quark (void);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error);
void zeitgeist_utils_assert_sig (gboolean condition, const gchar* error_message, GError** error);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range);
static void zeitgeist_time_range_finalize (GObject * obj);
static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * @param start_msec starting timestamp in number of milliseconds
     *        since the Unix Epoch
     * @param end_msec ending timestamp in number of milliseconds
     *        since the Unix Epoch
     * @return a newly allocated ZeitgeistTimeRange. Free with
     *        g_object_unref()
     */
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = (ZeitgeistTimeRange*) g_object_new (object_type, NULL);
	_tmp0_ = start_msec;
	zeitgeist_time_range_set_start (self, _tmp0_);
	_tmp1_ = end_msec;
	zeitgeist_time_range_set_end (self, _tmp1_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec) {
	return zeitgeist_time_range_construct (ZEITGEIST_TYPE_TIME_RANGE, start_msec, end_msec);
}


/**
     * @return a new time range starting from the beginning of the Unix
     *         Epoch stretching to the end of time
     */
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, G_MAXINT64);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void) {
	return zeitgeist_time_range_construct_anytime (ZEITGEIST_TYPE_TIME_RANGE);
}


/**
     * @return a new time range starting from the beggining of the
     *         Unix Epoch ending a the moment of invocation
     */
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	_tmp0_ = zeitgeist_timestamp_from_now ();
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, _tmp0_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void) {
	return zeitgeist_time_range_construct_to_now (ZEITGEIST_TYPE_TIME_RANGE);
}


/**
     * @return a new time range starting from the moment of invocation
     *         to the end of time
     */
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	_tmp0_ = zeitgeist_timestamp_from_now ();
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, _tmp0_, G_MAXINT64);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void) {
	return zeitgeist_time_range_construct_from_now (ZEITGEIST_TYPE_TIME_RANGE);
}


/**
     * Create a #TimeRange from a variant.
     *
     * @param variant a variant representing a #TimeRange
     * @return a new time range starting from the moment of invocation
     *         to the end of time
     */
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error) {
	ZeitgeistTimeRange * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_;
	gint64 start_msec = 0LL;
	gint64 end_msec = 0LL;
	GVariant* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	zeitgeist_utils_assert_sig (g_strcmp0 (_tmp1_, "(xx)") == 0, "Invalid D-Bus signature.", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	start_msec = (gint64) 0;
	end_msec = (gint64) 0;
	_tmp2_ = variant;
	g_variant_get (_tmp2_, "(xx)", &start_msec, &end_msec, NULL);
	_tmp3_ = start_msec;
	_tmp4_ = end_msec;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, _tmp3_, _tmp4_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error) {
	return zeitgeist_time_range_construct_from_variant (ZEITGEIST_TYPE_TIME_RANGE, variant, error);
}


/**
     * @return a new variant holding the time range
     */
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self) {
	GVariant* result = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start;
	_tmp1_ = self->priv->_end;
	_tmp2_ = g_variant_new ("(xx)", _tmp0_, _tmp1_, NULL);
	g_variant_ref_sink (_tmp2_);
	result = _tmp2_;
	return result;
}


/**
     * Check whether two time ranges are intersecting.
     *
     * @param time_range the second time range to compare with
     * @return a new time range representing the intersection
     */
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range) {
	ZeitgeistTimeRange* result = NULL;
	ZeitgeistTimeRange* _result_ = NULL;
	ZeitgeistTimeRange* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp15_;
	ZeitgeistTimeRange* _tmp16_;
	gint64 _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	_tmp0_ = zeitgeist_time_range_new ((gint64) 0, (gint64) 0);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_start;
	_tmp2_ = time_range;
	_tmp3_ = _tmp2_->priv->_start;
	if (_tmp1_ < _tmp3_) {
		gint64 _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		_tmp4_ = self->priv->_end;
		_tmp5_ = time_range;
		_tmp6_ = _tmp5_->priv->_start;
		if (_tmp4_ < _tmp6_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp7_;
			ZeitgeistTimeRange* _tmp8_;
			gint64 _tmp9_;
			_tmp7_ = _result_;
			_tmp8_ = time_range;
			_tmp9_ = _tmp8_->priv->_start;
			zeitgeist_time_range_set_start (_tmp7_, _tmp9_);
		}
	} else {
		gint64 _tmp10_;
		ZeitgeistTimeRange* _tmp11_;
		gint64 _tmp12_;
		_tmp10_ = self->priv->_start;
		_tmp11_ = time_range;
		_tmp12_ = _tmp11_->priv->_end;
		if (_tmp10_ > _tmp12_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp13_;
			gint64 _tmp14_;
			_tmp13_ = _result_;
			_tmp14_ = self->priv->_start;
			zeitgeist_time_range_set_start (_tmp13_, _tmp14_);
		}
	}
	_tmp15_ = self->priv->_end;
	_tmp16_ = time_range;
	_tmp17_ = _tmp16_->priv->_end;
	if (_tmp15_ < _tmp17_) {
		gint64 _tmp18_;
		ZeitgeistTimeRange* _tmp19_;
		gint64 _tmp20_;
		_tmp18_ = self->priv->_end;
		_tmp19_ = time_range;
		_tmp20_ = _tmp19_->priv->_start;
		if (_tmp18_ < _tmp20_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp21_;
			gint64 _tmp22_;
			_tmp21_ = _result_;
			_tmp22_ = self->priv->_end;
			zeitgeist_time_range_set_end (_tmp21_, _tmp22_);
		}
	} else {
		gint64 _tmp23_;
		ZeitgeistTimeRange* _tmp24_;
		gint64 _tmp25_;
		_tmp23_ = self->priv->_start;
		_tmp24_ = time_range;
		_tmp25_ = _tmp24_->priv->_end;
		if (_tmp23_ > _tmp25_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp26_;
			ZeitgeistTimeRange* _tmp27_;
			gint64 _tmp28_;
			_tmp26_ = _result_;
			_tmp27_ = time_range;
			_tmp28_ = _tmp27_->priv->_end;
			zeitgeist_time_range_set_end (_tmp26_, _tmp28_);
		}
	}
	result = _result_;
	return result;
}


gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_time_range_get_start (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_start = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_time_range_properties[ZEITGEIST_TIME_RANGE_START_PROPERTY]);
	}
}


gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_time_range_get_end (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_end = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_time_range_properties[ZEITGEIST_TIME_RANGE_END_PROPERTY]);
	}
}


static void zeitgeist_time_range_class_init (ZeitgeistTimeRangeClass * klass) {
	zeitgeist_time_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistTimeRangePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_time_range_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_time_range_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_time_range_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_START_PROPERTY, zeitgeist_time_range_properties[ZEITGEIST_TIME_RANGE_START_PROPERTY] = g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_END_PROPERTY, zeitgeist_time_range_properties[ZEITGEIST_TIME_RANGE_END_PROPERTY] = g_param_spec_int64 ("end", "end", "end", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zeitgeist_time_range_instance_init (ZeitgeistTimeRange * self) {
	self->priv = ZEITGEIST_TIME_RANGE_GET_PRIVATE (self);
}


static void zeitgeist_time_range_finalize (GObject * obj) {
	ZeitgeistTimeRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange);
	G_OBJECT_CLASS (zeitgeist_time_range_parent_class)->finalize (obj);
}


/**
 * Immutable representation of an interval in time, marked by a
 * beginning and an end
 *
 * A light, immutable, encapsulation of an interval in time, marked by
 * a beginning and an end.
 */
GType zeitgeist_time_range_get_type (void) {
	static volatile gsize zeitgeist_time_range_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_time_range_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistTimeRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_time_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistTimeRange), 0, (GInstanceInitFunc) zeitgeist_time_range_instance_init, NULL };
		GType zeitgeist_time_range_type_id;
		zeitgeist_time_range_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistTimeRange", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_time_range_type_id__volatile, zeitgeist_time_range_type_id);
	}
	return zeitgeist_time_range_type_id__volatile;
}


static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START_PROPERTY:
		g_value_set_int64 (value, zeitgeist_time_range_get_start (self));
		break;
		case ZEITGEIST_TIME_RANGE_END_PROPERTY:
		g_value_set_int64 (value, zeitgeist_time_range_get_end (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START_PROPERTY:
		zeitgeist_time_range_set_start (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_TIME_RANGE_END_PROPERTY:
		zeitgeist_time_range_set_end (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



