/* extension-store.c generated by valac 0.38.8, the Vala compiler
 * generated from extension-store.vala, do not modify */

/* extension-store.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;
typedef struct _ZeitgeistExtensionStorePrivate ZeitgeistExtensionStorePrivate;
enum  {
	ZEITGEIST_EXTENSION_STORE_0_PROPERTY,
	ZEITGEIST_EXTENSION_STORE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_store_properties[ZEITGEIST_EXTENSION_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _ZeitgeistExtensionStore {
	GObject parent_instance;
	ZeitgeistExtensionStorePrivate * priv;
};

struct _ZeitgeistExtensionStoreClass {
	GObjectClass parent_class;
};

struct _ZeitgeistExtensionStorePrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	sqlite3_stmt* storage_stmt;
	sqlite3_stmt* retrieval_stmt;
};


static gpointer zeitgeist_extension_store_parent_class = NULL;

GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStorePrivate))
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
static void zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self, GError** error);
void zeitgeist_extension_store_store (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, GVariant* data);
GVariant* zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, const GVariantType* format);
static void zeitgeist_extension_store_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine) {
	ZeitgeistExtensionStore * self = NULL;
	ZeitgeistEngine* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	sqlite3* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (engine != NULL, NULL);
	self = (ZeitgeistExtensionStore*) g_object_new (object_type, NULL);
	_tmp0_ = engine;
	_tmp1_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp3_;
	_tmp4_ = self->priv->database;
	_tmp5_ = _tmp4_->database;
	self->priv->db = _tmp5_;
	{
		zeitgeist_extension_store_prepare_queries (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("extension-store.vala:42: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine) {
	return zeitgeist_extension_store_construct (ZEITGEIST_TYPE_EXTENSION_STORE, engine);
}


static void zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	ZeitgeistSQLiteDatabase* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	ZeitgeistSQLiteDatabase* _tmp9_;
	sqlite3* _tmp10_;
	const gchar* _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_;
	ZeitgeistSQLiteDatabase* _tmp14_;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT OR REPLACE INTO extensions_conf (\n" \
"                    extension, key, value\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->priv->database;
	_tmp2_ = _tmp1_->database;
	_tmp3_ = sql;
	_tmp5_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	self->priv->storage_stmt = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = self->priv->database;
	_tmp7_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp6_, _tmp7_, "extension-store.vala:59: Storage query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = g_strdup ("\n" \
"                SELECT value\n" \
"                FROM extensions_conf\n" \
"                WHERE extension=? AND key=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp8_;
	_tmp9_ = self->priv->database;
	_tmp10_ = _tmp9_->database;
	_tmp11_ = sql;
	_tmp13_ = sqlite3_prepare_v2 (_tmp10_, _tmp11_, -1, &_tmp12_, NULL);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	self->priv->retrieval_stmt = _tmp12_;
	rc = _tmp13_;
	_tmp14_ = self->priv->database;
	_tmp15_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp14_, _tmp15_, "extension-store.vala:68: Retrieval query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


/**
         * Store the given Variant under the given (extension, key)
         * identifier, replacing any previous value.
         */
void zeitgeist_extension_store_store (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, GVariant* data) {
	gint rc = 0;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GDestroyNotify _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	GVariant* _tmp10_;
	void* _tmp11_;
	GVariant* _tmp12_;
	gsize _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (extension != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->storage_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->storage_stmt;
	_tmp2_ = extension;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp3_, -1, _tmp4_);
	_tmp5_ = self->priv->storage_stmt;
	_tmp6_ = key;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->storage_stmt;
	_tmp10_ = data;
	_tmp11_ = g_variant_get_data (_tmp10_);
	_tmp12_ = data;
	_tmp13_ = g_variant_get_size (_tmp12_);
	sqlite3_bind_blob (_tmp9_, 3, _tmp11_, (gint) _tmp13_, NULL);
	_tmp14_ = self->priv->storage_stmt;
	_tmp15_ = sqlite3_step (_tmp14_);
	rc = _tmp15_;
	_tmp16_ = rc;
	if (_tmp16_ != SQLITE_DONE) {
		gint _tmp19_;
		sqlite3* _tmp20_;
		const gchar* _tmp21_;
		{
			ZeitgeistSQLiteDatabase* _tmp17_;
			gint _tmp18_;
			_tmp17_ = self->priv->database;
			_tmp18_ = rc;
			zeitgeist_sq_lite_database_assert_not_corrupt (_tmp17_, _tmp18_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch5_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally5;
		__catch5_zeitgeist_engine_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = rc;
		_tmp20_ = self->priv->db;
		_tmp21_ = sqlite3_errmsg (_tmp20_);
		g_warning ("extension-store.vala:90: SQL error: %d, %s", _tmp19_, _tmp21_);
	}
}


/**
         * Retrieve a previously stored value.
         */
static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


GVariant* zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, const GVariantType* format) {
	GVariant* result = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GDestroyNotify _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	gint rc = 0;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	guchar* blob = NULL;
	gint blob_length1 = 0;
	gint _blob_size_ = 0;
	sqlite3_stmt* _tmp18_;
	void* _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GVariant* data = NULL;
	guchar* _tmp23_;
	gint _tmp23__length1;
	sqlite3_stmt* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->retrieval_stmt;
	_tmp2_ = extension;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp3_, -1, _tmp4_);
	_tmp5_ = self->priv->retrieval_stmt;
	_tmp6_ = key;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->retrieval_stmt;
	_tmp10_ = sqlite3_step (_tmp9_);
	rc = _tmp10_;
	_tmp11_ = rc;
	if (_tmp11_ != SQLITE_ROW) {
		gint _tmp12_;
		_tmp12_ = rc;
		if (_tmp12_ != SQLITE_DONE) {
			gint _tmp15_;
			sqlite3* _tmp16_;
			const gchar* _tmp17_;
			{
				ZeitgeistSQLiteDatabase* _tmp13_;
				gint _tmp14_;
				_tmp13_ = self->priv->database;
				_tmp14_ = rc;
				zeitgeist_sq_lite_database_assert_not_corrupt (_tmp13_, _tmp14_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch6_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally6;
			__catch6_zeitgeist_engine_error:
			{
				GError* err = NULL;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally6:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp15_ = rc;
			_tmp16_ = self->priv->db;
			_tmp17_ = sqlite3_errmsg (_tmp16_);
			g_warning ("extension-store.vala:113: SQL error: %d, %s", _tmp15_, _tmp17_);
		}
		result = NULL;
		return result;
	}
	_tmp18_ = self->priv->retrieval_stmt;
	_tmp19_ = sqlite3_column_blob (_tmp18_, 0);
	blob = (guchar*) _tmp19_;
	blob_length1 = -1;
	_blob_size_ = blob_length1;
	_tmp20_ = self->priv->retrieval_stmt;
	_tmp21_ = sqlite3_column_bytes (_tmp20_, 0);
	blob_length1 = _tmp21_;
	_tmp22_ = blob_length1;
	data = NULL;
	_tmp23_ = blob;
	_tmp23__length1 = blob_length1;
	if (_tmp23_ != NULL) {
		GByteArray* byte_array = NULL;
		guchar* _tmp24_;
		gint _tmp24__length1;
		GByteArray* _tmp25_;
		GByteArray* _tmp26_;
		guchar* _tmp27_;
		gint _tmp27__length1;
		const GVariantType* _tmp28_;
		GByteArray* _tmp29_;
		guint8* _tmp30_;
		gint _tmp30__length1;
		GByteArray* _tmp31_;
		GByteArray* _tmp32_;
		GVariant* _tmp33_;
		_tmp24_ = blob;
		_tmp24__length1 = blob_length1;
		_tmp25_ = g_byte_array_sized_new ((guint) _tmp24__length1);
		byte_array = _tmp25_;
		_tmp26_ = byte_array;
		_tmp27_ = blob;
		_tmp27__length1 = blob_length1;
		g_byte_array_append (_tmp26_, _tmp27_, _tmp27__length1);
		_tmp28_ = format;
		_tmp29_ = byte_array;
		_tmp30_ = _tmp29_->data;
		_tmp30__length1 = (gint) _tmp29_->len;
		_tmp31_ = byte_array;
		_tmp32_ = _g_byte_array_ref0 (_tmp31_);
		_tmp33_ = g_variant_new_from_data (_tmp28_, _tmp30_, _tmp30__length1, FALSE, g_byte_array_unref, _tmp32_);
		g_variant_ref_sink (_tmp33_);
		_g_variant_unref0 (data);
		data = _tmp33_;
		_g_byte_array_unref0 (byte_array);
	}
	_tmp34_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp34_);
	result = data;
	return result;
}


static void zeitgeist_extension_store_class_init (ZeitgeistExtensionStoreClass * klass) {
	zeitgeist_extension_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_store_finalize;
}


static void zeitgeist_extension_store_instance_init (ZeitgeistExtensionStore * self) {
	self->priv = ZEITGEIST_EXTENSION_STORE_GET_PRIVATE (self);
}


static void zeitgeist_extension_store_finalize (GObject * obj) {
	ZeitgeistExtensionStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	G_OBJECT_CLASS (zeitgeist_extension_store_parent_class)->finalize (obj);
}


GType zeitgeist_extension_store_get_type (void) {
	static volatile gsize zeitgeist_extension_store_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionStore), 0, (GInstanceInitFunc) zeitgeist_extension_store_instance_init, NULL };
		GType zeitgeist_extension_store_type_id;
		zeitgeist_extension_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionStore", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_extension_store_type_id__volatile, zeitgeist_extension_store_type_id);
	}
	return zeitgeist_extension_store_type_id__volatile;
}



