package gnu.xml.validation.xmlschema;

import gnu.xml.validation.datatypes.Annotation;
import gnu.xml.validation.datatypes.Type;
import javax.xml.namespace.QName;

/**
 * An XML Schema element declaration schema component.
 *
 * @author <a href='mailto:dog@gnu.org'>Chris Burdess</a>
 */
class ElementDeclaration
  extends Particle
{

  static final int NONE = 0x00;
  static final int EXTENSION = 0x01;
  static final int RESTRICTION = 0x02;
  static final int SUBSTITUTION = 0x04;

  /**
   * The name of the element to which this declaration refers.
   */
  final QName name;

  /**
   * The type definition corresponding to this element.
   */
  final Type datatype;
  
  /**
   * The scope of this schema component.
   * One of GLOBAL, LOCAL, or ABSENT.
   */
  final int scope;

  /**
   * The constraint type.
   * One of NONE, DEFAULT, FIXED.
   */
  final int type;
  
  /**
   * The value constraint.
   */
  final String value;

  final boolean nillable;

  // TODO identity-constraint definitions
  
  final ElementDeclaration substitutionGroup;

  final int substitutionGroupExclusions;

  final int disallowedSubstitutions;

  final boolean isAbstract;

  /**
   * The annotation associated with this attribute declaration, if any.
   */
  final Annotation annotation;

  ElementDeclaration(String name,
                     Type datatype,
                     int scope, int type, String value,
                     boolean nillable,
                     ElementDeclaration substitutionGroup,
                     int substitutionGroupExclusions,
                     int disallowedSubstitutions,
                     boolean isAbstract,
                     Annotation annotation)
  {
    this.name = name;
    this.datatype = datatype;
    this.scope = scope;
    this.type = type;
    this.value = value;
    this.nillable = nillable;
    this.substitutionGroup = substitutionGroup;
    this.substitutionGroupExclusions = substitutionGroupExclusions;
    this.disallowedSubstitutions = disallowedSubstitutions;
    this.isAbstract = isAbstract;
    this.annotation = annotation;
  }
  
}

