extern void abort (void);

typedef int V2SI __attribute__ ((vector_size (8)));
typedef unsigned int V2USI __attribute__ ((vector_size (8)));
typedef float V2SF __attribute__ ((vector_size (8)));
typedef short V2HI __attribute__ ((vector_size (4)));
typedef unsigned int V2UHI __attribute__ ((vector_size (4)));

long long
test1 (V2SF x)
{
  return (long long) (V2SI) x;
}

long long
test2 (V2SF x)
{
  return (long long) x;
}

long long
test3 (V2SI x)
{
  return (long long) (V2SF) x;
}

int
main (void)
{
  if (sizeof (short) != 2 || sizeof (int) != 4 || sizeof (long long) != 8)
    return 0;

  V2SF x = { 2.0, 2.0 };
  union { long long l; float f[2]; int i[2]; } u;
  u.l = test1 (x);
  if (u.f[0] != 2.0 || u.f[1] != 2.0)
    abort ();

  V2SF y = { 6.0, 6.0 };
  u.l = test2 (y);
  if (u.f[0] != 6.0 || u.f[1] != 6.0)
    abort ();

  V2SI z = { 4, 4 };
  u.l = test3 (z);
  if (u.i[0] != 4 || u.i[1] != 4)
    abort ();
  return 0;
}
