/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.BitString;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;

class GnuRSAPublicKey
implements RSAPublicKey {
    private final RSAPublicKeySpec spec;
    private byte[] encodedKey;

    public BigInteger getModulus() {
        return this.spec.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.spec.getPublicExponent();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        ArrayList<DERValue> key = new ArrayList<DERValue>(2);
        key.add(new DERValue(2, this.getModulus()));
        key.add(new DERValue(2, this.getPublicExponent()));
        DERValue rsapk = new DERValue(48, key);
        ArrayList<DERValue> alg = new ArrayList<DERValue>(2);
        alg.add(new DERValue(6, new OID("1.2.840.113549.1.1.1")));
        alg.add(new DERValue(5, null));
        ArrayList<DERValue> spki = new ArrayList<DERValue>(2);
        spki.add(new DERValue(48, alg));
        spki.add(new DERValue(3, new BitString(rsapk.getEncoded())));
        this.encodedKey = new DERValue(48, spki).getEncoded();
        return (byte[])this.encodedKey.clone();
    }

    public GnuRSAPublicKey(RSAPublicKeySpec spec) {
        this.spec = spec;
    }
}

