/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class FixedSizeArrayParser
implements Parser {
    private final Parser elemParser;
    private final Field targetField;
    private final int elemNumber;

    public FixedSizeArrayParser(int elemNumber, Parser elemParser, Field f) {
        this.targetField = f;
        this.elemNumber = elemNumber;
        this.elemParser = elemParser;
    }

    @Override
    public int getSize(Message srcObj) {
        int size = 0;
        Object arr = ReflectUtil.justGet(srcObj, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.getSize((Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int size = 0;
        Object arr = Array.newInstance(this.targetField.getType().getComponentType(), this.elemNumber);
        ReflectUtil.justSet(dstObj, this.targetField, arr);
        for (int i = 0; i < this.elemNumber; ++i) {
            Message elemObj = (Message)ReflectUtil.justInstantiate(this.targetField.getType().getComponentType());
            Array.set(arr, i, elemObj);
            size += this.elemParser.parse(srcBuf, frameOffset - size, frameObj, elemObj, null);
        }
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        int size = 0;
        Object arr = ReflectUtil.justGet(srcObj, this.targetField);
        if (Array.getLength(arr) != this.elemNumber) {
            throw new AssertionError((Object)"wrong number of elements");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.write(dstBuf, (Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        Object arr = ReflectUtil.justGet(m, this.targetField);
        for (int i = 0; i < Array.getLength(arr); ++i) {
            this.elemParser.patch((Message)Array.get(arr, i), frameSize, null, frameObj);
        }
    }

    @Override
    public int getStaticSize() {
        return this.elemNumber * this.elemParser.getStaticSize();
    }
}

