/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.IntegerUtil;
import org.gnunet.construct.parsers.Parser;

public class IntegerFillParser
implements Parser {
    private final Field targetField;
    private final boolean signed;
    private final int byteSize;

    public IntegerFillParser(Field targetField, boolean signed, int byteSize) {
        this.targetField = targetField;
        this.signed = signed;
        this.byteSize = byteSize;
    }

    @Override
    public int getSize(Message srcObj) {
        Object arr = ReflectUtil.justGet(srcObj, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        return this.byteSize * Array.getLength(arr);
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameStart, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        if (frameSizePath == null) {
            throw new AssertionError((Object)"IntegerFillParser expects a non-null frameSizePath. Did you specify a @FrameSize field?");
        }
        int frameSize = ReflectUtil.justGetInt(frameObj, frameSizePath);
        int remaining = frameStart + frameSize - srcBuf.position();
        int elemNumber = remaining / this.byteSize;
        Class<?> arrayElementType = this.targetField.getType().getComponentType();
        if (!arrayElementType.isPrimitive()) {
            throw new AssertionError((Object)("IntegerFillParser is expected to be of primitive type, not " + arrayElementType));
        }
        Object arr = Array.newInstance(arrayElementType, elemNumber);
        ReflectUtil.justSet(dstObj, this.targetField, arr);
        for (int i = 0; i < elemNumber; ++i) {
            long v = IntegerUtil.readLong(srcBuf, this.signed, this.byteSize);
            ReflectUtil.justSetArray(arr, i, v);
        }
        return remaining;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        Object arr = ReflectUtil.justGet(srcObj, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            IntegerUtil.writeLong(Array.getLong(arr, i), dstBuf, this.signed, this.byteSize);
        }
        return this.getSize(srcObj);
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        if (frameSizePath == null) {
            throw new AssertionError((Object)"IntegerFillParser expects a non-null frameSizePath. Did you specify a @FrameSize field?");
        }
        ReflectUtil.justSetInt(frameObj, frameSizePath, frameSize);
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

