/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.dht;

import com.google.common.base.Charsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.gnunet.dht.BlockType;
import org.gnunet.dht.MonitorGetHandler;
import org.gnunet.dht.MonitorGetResponseHandler;
import org.gnunet.dht.MonitorPutHandler;
import org.gnunet.dht.ResultCallback;
import org.gnunet.dht.RouteOption;
import org.gnunet.dht.messages.ClientGetMessage;
import org.gnunet.dht.messages.ClientPutConfirmationMessage;
import org.gnunet.dht.messages.ClientPutMessage;
import org.gnunet.dht.messages.ClientResultMessage;
import org.gnunet.dht.messages.MonitorGetMessage;
import org.gnunet.dht.messages.MonitorGetRespMessage;
import org.gnunet.dht.messages.MonitorPutMessage;
import org.gnunet.dht.messages.MonitorStartStop;
import org.gnunet.mq.Envelope;
import org.gnunet.requests.MatchingRequestContainer;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.SequentialRequestContainer;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.AbsoluteTimeMessage;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.Continuation;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedHashTable {
    private static final Logger logger = LoggerFactory.getLogger(DistributedHashTable.class);
    private Client client;
    private long nextUID = 1L;
    private MatchingRequestContainer<Long, PutRequest> putRequests;
    private MatchingRequestContainer<Long, GetRequest> getRequests;
    private SequentialRequestContainer<MonitorRequest> monitorRequests;

    public DistributedHashTable(Configuration cfg) {
        this.client = new Client("dht", cfg);
        this.client.installReceiver(new DHTMessageReceiver());
        this.putRequests = new MatchingRequestContainer(this.client);
        this.getRequests = new MatchingRequestContainer(this.client);
        this.monitorRequests = new SequentialRequestContainer(this.client);
    }

    public void put(HashCode key, byte[] data, int replicationLevel, Set<RouteOption> routeOptions, int type, AbsoluteTime expiration, Continuation cont) {
        PutRequest pr = new PutRequest();
        pr.key = key;
        pr.data = data;
        pr.replicationLevel = replicationLevel;
        pr.expiration = expiration;
        pr.type = type;
        pr.cont = cont;
        pr.options = 0;
        for (RouteOption routeOption : routeOptions) {
            pr.options |= routeOption.val;
        }
        this.putRequests.addRequest(pr.uid, pr);
    }

    public Cancelable startGet(RelativeTime timeout, int type, HashCode key, int replication, EnumSet<RouteOption> routeOptions, byte[] xquery, ResultCallback cb) {
        GetRequest getRequest = new GetRequest();
        getRequest.key = key;
        getRequest.cb = cb;
        getRequest.type = type;
        getRequest.replication = type;
        getRequest.xquery = xquery;
        getRequest.replication = replication;
        getRequest.options = 0;
        for (RouteOption routeOption : routeOptions) {
            getRequest.options |= routeOption.val;
        }
        return this.getRequests.addRequest(getRequest.uid, getRequest);
    }

    public Cancelable startMonitor(int blockType, HashCode key, MonitorGetHandler getHandler, MonitorGetResponseHandler getResponseHandler, MonitorPutHandler putHandler) {
        MonitorRequest monitorRequest = new MonitorRequest();
        monitorRequest.blockType = blockType;
        monitorRequest.key = key;
        monitorRequest.getHandler = getHandler;
        monitorRequest.getResponseHandler = getResponseHandler;
        monitorRequest.putHandler = putHandler;
        return this.monitorRequests.addRequest(monitorRequest);
    }

    public void destroy() {
        this.client.disconnect();
    }

    public static void main(String[] args) {
        new Program(){
            @Argument(action=ArgumentAction.SET, shortname="p", longname="put", description="set a value in the DHT; default is get")
            boolean modePut = false;
            @Argument(action=ArgumentAction.SET, shortname="m", longname="monitor", description="monitor requests going to the local DHT")
            boolean monitor = false;
            @Argument(action=ArgumentAction.STORE_STRING, shortname="d", longname="data", description="data (only used with --put)")
            String data = null;
            @Argument(action=ArgumentAction.STORE_STRING, shortname="k", longname="key", description="key used for the operation")
            String key = null;
            @Argument(action=ArgumentAction.STORE_NUMBER, shortname="r", longname="replication", description="desired replication (only used with --put)")
            int replication = 5;

            @Override
            public void run() {
                if (this.modePut) {
                    if (this.key == null) {
                        System.out.println("key required");
                        return;
                    }
                    if (this.data == null) {
                        System.out.println("data required on put");
                        return;
                    }
                    final DistributedHashTable dht = new DistributedHashTable(this.cfg);
                    dht.put(new HashCode(this.key), this.data.getBytes(), this.replication, EnumSet.of(RouteOption.NONE), BlockType.TEST.val, AbsoluteTime.now().add(RelativeTime.HOUR), new Continuation(){

                        @Override
                        public void cont(boolean success) {
                            if (success) {
                                System.out.println("put getRequestIdentifier sent");
                            } else {
                                System.out.println("error");
                            }
                            dht.destroy();
                        }
                    });
                } else if (this.monitor) {
                    DistributedHashTable dht = new DistributedHashTable(this.cfg);
                    dht.startMonitor(BlockType.TEST.val, null, new MonitorGetHandler(){

                        @Override
                        public void onGet(int options, int type, int hopCount, int desiredReplicationLevel, PeerIdentity[] getPath, HashCode key) {
                            System.out.println("get monitored");
                        }
                    }, new MonitorGetResponseHandler(){

                        @Override
                        public void onGetResponse(int type, PeerIdentity[] getPath, PeerIdentity[] putPath, AbsoluteTimeMessage expiration, HashCode key, byte[] data) {
                            System.out.println("get response monitored");
                        }
                    }, new MonitorPutHandler(){

                        @Override
                        public void onPut(int options, int type, int hop_count, AbsoluteTimeMessage expirationTime, PeerIdentity[] putPath, HashCode key, byte[] data) {
                            System.out.println("put monitored");
                        }
                    });
                } else {
                    if (this.key == null) {
                        System.out.println("key required");
                        return;
                    }
                    if (this.data != null) {
                        System.out.println("get does not take data as an option");
                        return;
                    }
                    DistributedHashTable dht = new DistributedHashTable(this.cfg);
                    dht.startGet(RelativeTime.SECOND, BlockType.TEST.val, new HashCode(this.key), this.replication, null, new byte[0], new ResultCallback(){

                        @Override
                        public void handleResult(AbsoluteTime expiration, HashCode key, List<PeerIdentity> getPath, List<PeerIdentity> putPath, BlockType type, byte[] data) {
                            System.out.println("got result:");
                            System.out.println(new String(data, Charsets.UTF_8));
                        }
                    });
                }
            }
        }.start(args);
    }

    private class DHTMessageReceiver
    extends RunaboutMessageReceiver {
        private DHTMessageReceiver() {
        }

        public void visit(ClientPutConfirmationMessage pcm) {
            PutRequest thePutRequest = (PutRequest)DistributedHashTable.this.putRequests.getAndRetireRequest(pcm.uid);
            if (thePutRequest == null) {
                logger.warn("getRequestIdentifier UID not found");
                return;
            }
            if (thePutRequest.cont != null) {
                thePutRequest.cont.cont(true);
            }
        }

        public void visit(ClientResultMessage rm) {
            GetRequest theGetRequest = (GetRequest)DistributedHashTable.this.getRequests.getAndRetireRequest(rm.uid);
            if (theGetRequest == null) {
                logger.warn("getRequestIdentifier UID not found");
                return;
            }
            theGetRequest.cb.handleResult(AbsoluteTime.fromNetwork(rm.expiration), rm.key, null, null, BlockType.TEST, rm.data);
        }

        public void visit(MonitorGetMessage monitorGetMessage) {
            for (RequestIdentifier monitorRequest : DistributedHashTable.this.monitorRequests.iter()) {
                boolean typeOk = monitorGetMessage.type == BlockType.ANY.val || monitorGetMessage.type == ((MonitorRequest)monitorRequest.getRequest()).blockType;
                boolean keyOk = monitorGetMessage.key.isAllZero() || monitorGetMessage.key.equals(((MonitorRequest)monitorRequest.getRequest()).key);
                if (!keyOk || !typeOk || ((MonitorRequest)monitorRequest.getRequest()).getHandler == null) continue;
                ((MonitorRequest)monitorRequest.getRequest()).getHandler.onGet(monitorGetMessage.options, monitorGetMessage.type, monitorGetMessage.hopCount, monitorGetMessage.desiredReplicationLevel, monitorGetMessage.getPath, monitorGetMessage.key);
            }
        }

        public void visit(MonitorGetRespMessage monitorGetRespMessage) {
            for (RequestIdentifier monitorRequest : DistributedHashTable.this.monitorRequests.iter()) {
                boolean typeOk = monitorGetRespMessage.type == BlockType.ANY.val || monitorGetRespMessage.type == ((MonitorRequest)monitorRequest.getRequest()).blockType;
                boolean keyOk = monitorGetRespMessage.key.isAllZero() || monitorGetRespMessage.key.equals(((MonitorRequest)monitorRequest.getRequest()).key);
                if (!keyOk || !typeOk || ((MonitorRequest)monitorRequest.getRequest()).getResponseHandler == null) continue;
                ((MonitorRequest)monitorRequest.getRequest()).getResponseHandler.onGetResponse(monitorGetRespMessage.type, monitorGetRespMessage.getPath, monitorGetRespMessage.putPath, monitorGetRespMessage.expiration, monitorGetRespMessage.key, monitorGetRespMessage.data);
            }
        }

        public void visit(MonitorPutMessage monitorPutMessage) {
            for (RequestIdentifier monitorRequest : DistributedHashTable.this.monitorRequests.iter()) {
                boolean typeOk = monitorPutMessage.type == BlockType.ANY.val || monitorPutMessage.type == ((MonitorRequest)monitorRequest.getRequest()).blockType;
                boolean keyOk = monitorPutMessage.key.isAllZero() || monitorPutMessage.key.equals(((MonitorRequest)monitorRequest.getRequest()).key);
                if (!keyOk || !typeOk || ((MonitorRequest)monitorRequest.getRequest()).putHandler == null) continue;
                ((MonitorRequest)monitorRequest.getRequest()).putHandler.onPut(monitorPutMessage.options, monitorPutMessage.type, monitorPutMessage.hopCount, monitorPutMessage.expirationTime, monitorPutMessage.putPath, monitorPutMessage.key, monitorPutMessage.data);
            }
        }

        @Override
        public void handleError() {
        }
    }

    private class MonitorRequest
    extends Request {
        public int blockType;
        public HashCode key;
        public MonitorGetHandler getHandler;
        public MonitorGetResponseHandler getResponseHandler;
        public MonitorPutHandler putHandler;

        private MonitorRequest() {
        }

        @Override
        public Envelope assembleRequest() {
            MonitorStartStop mss = new MonitorStartStop();
            if (this.key != null) {
                mss.filterKey = 1;
                mss.key = this.key;
            } else {
                mss.key = new HashCode();
            }
            if (this.getHandler != null) {
                mss.get = 1;
            }
            if (this.getResponseHandler != null) {
                mss.getResp = 1;
            }
            if (this.putHandler != null) {
                mss.put = 1;
            }
            mss.type = this.blockType;
            return new Envelope(mss);
        }

        public void onCancel() {
            MonitorRequest cancelRequest = new MonitorRequest();
            cancelRequest.getHandler = null;
            cancelRequest.getResponseHandler = null;
            cancelRequest.putHandler = null;
            DistributedHashTable.this.monitorRequests.addRequest(cancelRequest);
            DistributedHashTable.this.monitorRequests.addRequest(cancelRequest);
        }
    }

    private class GetRequest
    extends Request {
        public long uid;
        public HashCode key;
        public ResultCallback cb;
        public int type;
        public int replication;
        public byte[] xquery;
        public int options;

        public GetRequest() {
            this.uid = DistributedHashTable.this.nextUID++;
        }

        @Override
        public Envelope assembleRequest() {
            ClientGetMessage gm = new ClientGetMessage();
            gm.desiredReplicationLevel = this.replication;
            gm.type = this.type;
            gm.xquery = this.xquery == null ? new byte[]{} : this.xquery;
            gm.key = this.key;
            gm.uniqueId = this.uid;
            gm.options = this.options;
            return new Envelope(gm);
        }

        public void onCancel() {
        }
    }

    private class PutRequest
    extends Request {
        public byte[] data;
        public HashCode key;
        public int replicationLevel;
        public AbsoluteTime expiration;
        public int type;
        public Continuation cont;
        public long uid;
        private int options;

        public PutRequest() {
            this.uid = DistributedHashTable.this.nextUID++;
        }

        @Override
        public Envelope assembleRequest() {
            ClientPutMessage cpm = new ClientPutMessage();
            cpm.data = this.data;
            cpm.hash = this.key;
            cpm.desiredReplicationLevel = this.replicationLevel;
            cpm.expiration = this.expiration.asMessage();
            cpm.type = this.type;
            cpm.uid = this.uid;
            cpm.options = this.options;
            return new Envelope(cpm);
        }

        public void onCancel() {
        }
    }
}

