/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.gnunet.voting.VotingParameters;

public abstract class Parameters {
    public static final int elgamalBits = 1024;
    public static final BigInteger elgamalQ = new BigInteger("0451a3e9eb4f4596ebe8d895046fde65f5fa6537a134d040a70ac51a1894b26ca359f79144118b95e7987e047bb93ba65a027cde001537b3584d3cec086b3e27c659df6e303071e477c3a58db26fb8b63e958016d4407134a1c6ad3bb735af929e46fab50b58e3e72c6f783e01eda411c556fe2951aa513f6942d860b3ae569f9", 16);
    public static final BigInteger elgamalP = new BigInteger("08a347d3d69e8b2dd7d1b12a08dfbccbebf4ca6f4269a0814e158a34312964d946b3ef228823172bcf30fc08f772774cb404f9bc002a6f66b09a79d810d67c4f8cb3bedc6060e3c8ef874b1b64df716c7d2b002da880e269438d5a776e6b5f253c8df56a16b1c7ce58def07c03db48238aadfc52a354a27ed285b0c1675cad3f3", 16);
    public static final BigInteger elgamalG = new BigInteger("05c00c36d2e822950087ef09d8252994adc4e48fe3ec70269f035b46063aff0c99b633fd64df4302442e1914c829a41505a275438871f365e91c123d5303ef9e90f4b8cb89bf86cc9b513e74a726349cfd9f953674fab5d511e1c078fc72d72b34086fc82b4b951989eb85325cb203ff98df76bc366bba1d7024c3650f60d0da", 16);

    public static BigInteger randomQ() {
        BigInteger y;
        SecureRandom r = new SecureRandom();
        while ((y = new BigInteger(1023, r)).compareTo(BigInteger.ONE) == 0 || y.compareTo(elgamalQ) >= 0) {
        }
        return y;
    }

    public static BigInteger modPowG(BigInteger exp) {
        return elgamalG.modPow(exp, elgamalP);
    }

    public static BigInteger[] generateGenerators(int i) {
        BigInteger[] generators = new BigInteger[i];
        for (int j = 0; j < i; ++j) {
            generators[j] = VotingParameters.selectSubgroupGenerator(elgamalP, elgamalQ);
        }
        return generators;
    }
}

