/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.secretsharing.Ciphertext;
import org.gnunet.secretsharing.Parameters;
import org.gnunet.secretsharing.ThresholdPublicKey;
import org.gnunet.util.BigIntegers;

public class Plaintext
implements Message {
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] bits;

    public static Plaintext generate(BigInteger exp) {
        BigInteger val = Parameters.elgamalG.modPow(exp, Parameters.elgamalP);
        Plaintext plaintext = new Plaintext();
        plaintext.bits = BigIntegers.serializeUnsigned(val, 1024);
        return plaintext;
    }

    public long[] bruteForceDiscreteLog(long l, BigInteger[] generators) {
        BigInteger needle = new BigInteger(1, this.bits);
        if (l == 0L) {
            if (needle.equals(BigInteger.ONE)) {
                return new long[0];
            }
            return null;
        }
        long[] combo = new long[generators.length];
        boolean success = Plaintext.bruteForceDiscreteLog(l, combo, needle, BigInteger.ONE, generators, 0);
        if (success) {
            return combo;
        }
        return null;
    }

    private static boolean bruteForceDiscreteLog(long l, long[] combo, BigInteger needle, BigInteger haystack, BigInteger[] generators, int genIdx) {
        if (l == 0L) {
            combo[genIdx] = 0L;
            return haystack.equals(needle);
        }
        if (genIdx == generators.length - 1) {
            combo[genIdx] = l;
            BigInteger myHay = haystack.multiply(generators[genIdx].modPow(BigInteger.valueOf(l), Parameters.elgamalP)).mod(Parameters.elgamalP);
            return myHay.equals(needle);
        }
        BigInteger myHay = haystack;
        int i = 0;
        while ((long)i <= l) {
            combo[genIdx] = i;
            boolean success = Plaintext.bruteForceDiscreteLog(l - (long)i, combo, needle, myHay, generators, genIdx + 1);
            if (success) {
                return true;
            }
            myHay = myHay.multiply(generators[genIdx]).mod(Parameters.elgamalP);
            ++i;
        }
        return false;
    }

    public Ciphertext encrypt(ThresholdPublicKey publicKey) {
        BigInteger y;
        SecureRandom secureRandom = new SecureRandom();
        BigInteger m = new BigInteger(1, this.bits);
        BigInteger h = new BigInteger(1, publicKey.bits);
        while ((y = new BigInteger(1023, secureRandom)).compareTo(BigInteger.ONE) == 0 || y.compareTo(Parameters.elgamalQ) >= 0) {
        }
        BigInteger c_1 = Parameters.elgamalG.modPow(y, Parameters.elgamalP);
        BigInteger c_2 = m.multiply(h.modPow(y, Parameters.elgamalP)).mod(Parameters.elgamalP);
        Ciphertext ciphertext = new Ciphertext();
        ciphertext.c_1 = BigIntegers.serializeUnsigned(c_1, 1024);
        ciphertext.c_2 = BigIntegers.serializeUnsigned(c_2, 1024);
        return ciphertext;
    }

    public String toString() {
        return "Plaintext{bits=" + Arrays.toString(this.bits) + '}';
    }
}

