/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.gnunet.construct.FillWith;
import org.gnunet.construct.Message;
import org.gnunet.construct.MessageUnion;
import org.gnunet.construct.NestedMessage;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.UInt32;
import org.gnunet.construct.UInt8;
import org.gnunet.construct.Union;
import org.gnunet.construct.ZeroTerminatedString;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.Connection;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageReceiver;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolver {
    private static final Logger logger = LoggerFactory.getLogger(Resolver.class);
    private static Resolver singletonInstance;
    private Configuration cfg;
    private Client client;
    private LinkedList<ResolveHandle> queuedRequests = new LinkedList();
    private boolean resolveActive = false;

    public static InetAddress getInetAddressFromString(String ipString) {
        try {
            return InetAddresses.forString((String)ipString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    private void lazyConnect() {
        if (this.client == null) {
            if (this.cfg == null) {
                throw new AssertionError((Object)"Resolver has no Configuration");
            }
            this.client = new Client("resolver", this.cfg);
        }
    }

    private InetAddress getInet4Localhost() {
        try {
            return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException();
        }
    }

    private InetAddress getInet6Localhost() {
        try {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException();
        }
    }

    public Cancelable resolveHostname(String hostname, RelativeTime timeout, AddressCallback cb) {
        if (hostname.equalsIgnoreCase("localhost")) {
            logger.debug("resolving address locally");
            cb.onAddress(this.getInet6Localhost());
            cb.onAddress(this.getInet4Localhost());
            cb.onFinished();
            return null;
        }
        if (hostname.equalsIgnoreCase("ip6-localhost")) {
            cb.onAddress(this.getInet6Localhost());
            cb.onFinished();
            return null;
        }
        InetAddress inetAddr = Resolver.getInetAddressFromString(hostname);
        if (inetAddr != null) {
            cb.onAddress(inetAddr);
            cb.onFinished();
            return null;
        }
        ResolveHandle rh = new ResolveHandle();
        rh.hostname = hostname;
        rh.deadline = timeout.toAbsolute();
        rh.cb = cb;
        this.queuedRequests.addLast(rh);
        this.handleNextRequest();
        return rh;
    }

    private void handleNextRequest() {
        if (!this.resolveActive && !this.queuedRequests.isEmpty()) {
            ResolveHandle rh = this.queuedRequests.pollFirst();
            this.handleRequest(rh);
        }
    }

    private void handleRequest(final ResolveHandle rh) {
        if (this.resolveActive) {
            throw new AssertionError((Object)"resolveActive but new resolve started");
        }
        this.resolveActive = true;
        this.lazyConnect();
        final GetMessage req = new GetMessage();
        req.direction = 0;
        req.domain = 0;
        TextualAddress textAddr = new TextualAddress();
        textAddr.addr = rh.hostname;
        req.addr = textAddr;
        final AbsoluteTime deadline = rh.deadline;
        logger.debug("deadline is " + deadline + " | now is " + AbsoluteTime.now());
        logger.debug("remaining is " + deadline.getRemaining());
        rh.transmitTask = this.client.notifyTransmitReady(deadline.getRemaining(), true, 0, new MessageTransmitter(){

            @Override
            public void transmit(Connection.MessageSink sink) {
                if (sink == null) {
                    Resolver.this.onTimeout(rh);
                    return;
                }
                sink.send(req);
                rh.transmitTask = null;
                logger.debug("recv in notifyTransmitReady cb");
                Resolver.this.client.receiveOne(deadline.getRemaining(), new MessageReceiver(){

                    @Override
                    public void process(GnunetMessage.Body msg) {
                        ResolverResponse gmsg = (ResolverResponse)msg;
                        if (gmsg.responseBody != null) {
                            try {
                                int len = gmsg.responseBody.addr.length;
                                if (len != 4 && len != 16) {
                                    throw new ProtocolViolationException("malformed address message");
                                }
                                InetAddress in_addr = InetAddress.getByAddress(gmsg.responseBody.addr);
                                rh.cb.onAddress(in_addr);
                                Resolver.this.client.receiveOne(deadline.getRemaining(), this);
                            }
                            catch (UnknownHostException e) {
                                throw new ProtocolViolationException("malformed address");
                            }
                        } else {
                            Resolver.this.resolveActive = false;
                            rh.cb.onFinished();
                            Resolver.this.handleNextRequest();
                        }
                    }

                    @Override
                    public void handleError() {
                        Resolver.this.onTimeout(rh);
                    }
                });
            }

            @Override
            public void handleError() {
                rh.cb.onTimeout();
            }
        });
    }

    private void onTimeout(ResolveHandle h) {
        this.resolveActive = false;
        h.cb.onTimeout();
        this.handleNextRequest();
    }

    public static Resolver getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new Resolver();
        }
        return singletonInstance;
    }

    public static String ipToString(InetAddress addr) {
        byte[] a = addr.getAddress();
        if (a.length == 4) {
            return addr.getHostAddress();
        }
        if (a.length == 16) {
            String s = addr.getHostAddress();
            return s.replaceFirst("[:]?0[:](0[:])+0?", "::");
        }
        throw new RuntimeException("unknown InetAddress format");
    }

    public static void main(String[] argv) {
        new Program(){
            @Argument(shortname="r", longname="reverse", description="do reverse dns lookup", action=ArgumentAction.SET)
            boolean isReverse;

            @Override
            public void run() {
                if (this.isReverse) {
                    System.out.println("reverse lookup not supported");
                } else {
                    this.resolve();
                }
            }

            public void resolve() {
                final RelativeTime timeout = RelativeTime.SECOND;
                if (this.unprocessedArgs.length == 0) {
                    logger.warn("no hostname(s) given");
                } else {
                    logger.info("resolving hostname '" + this.unprocessedArgs[0] + "'");
                    Resolver.getInstance().resolveHostname(this.unprocessedArgs[0], timeout, new AddressCallback(){
                        int next = 1;

                        @Override
                        public void onAddress(InetAddress addr) {
                            System.out.println(Resolver.ipToString(addr));
                        }

                        @Override
                        public void onFinished() {
                            logger.info("resolve finished");
                            this.next();
                        }

                        @Override
                        public void onTimeout() {
                            logger.warn("resolve timed out");
                            this.next();
                        }

                        public void next() {
                            if (unprocessedArgs.length > this.next) {
                                logger.info("resolving hostname '" + unprocessedArgs[this.next] + "'");
                                Resolver.getInstance().resolveHostname(unprocessedArgs[this.next], timeout, this);
                                ++this.next;
                            }
                        }
                    });
                }
            }

            @Override
            protected String makeHelpText() {
                return "tool for forward and reverse DNS lookup";
            }
        }.start(argv);
    }

    public class ResolveHandle
    implements Cancelable {
        private String hostname;
        private AbsoluteTime deadline;
        private AddressCallback cb;
        private boolean finished = false;
        private boolean canceled = false;
        private Cancelable transmitTask = null;

        @Override
        public void cancel() {
            if (this.finished) {
                throw new AssertionError((Object)"Resolve already finished");
            }
            if (this.canceled) {
                throw new AssertionError((Object)"ResolveHandle canceled twice");
            }
            if (Resolver.this.queuedRequests.contains(this)) {
                Resolver.this.queuedRequests.remove(this);
            } else if (this.transmitTask != null) {
                this.transmitTask.cancel();
            }
            this.canceled = true;
        }
    }

    public static interface AddressCallback {
        public void onAddress(InetAddress var1);

        public void onFinished();

        public void onTimeout();
    }

    public static class ResponseBody
    implements Message {
        @FillWith
        @UInt8
        public byte[] addr;
    }

    public static class ResolverResponse
    implements GnunetMessage.Body {
        @NestedMessage(optional=true)
        public ResponseBody responseBody;
    }

    public static class NumericAddress
    implements Address {
        @FillWith
        @UInt8
        public byte[] addr;
    }

    public static class TextualAddress
    implements Address {
        @ZeroTerminatedString
        public String addr;
    }

    public static interface Address
    extends MessageUnion {
    }

    public static class GetMessage
    implements GnunetMessage.Body {
        static final int DIRECTION_GET_IP = 0;
        static final int DIRECTION_GET_NAME = 1;
        static final int AF_UNSPEC = 0;
        static final int AF_INET = 2;
        static final int AF_INET6 = 10;
        @UInt32
        public int direction;
        @UInt32
        public int domain;
        @Union(tag="direction", optional=true)
        public Address addr;
    }
}

