/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class CryptoUtil {
    public static final Random random = new Random();

    public static BigInteger createRandomInRange(BigInteger min, BigInteger max) {
        int cmp = min.compareTo(max);
        if (cmp >= 0) {
            if (cmp > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return CryptoUtil.createRandomInRange(BigInteger.ZERO, max.subtract(min)).add(min);
        }
        for (int i = 0; i < 1000; ++i) {
            BigInteger x = new BigInteger(max.bitLength(), random);
            if (x.compareTo(min) < 0 || x.compareTo(max) > 0) continue;
            return x;
        }
        return new BigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    public static BigInteger evaluatePolynomial(BigInteger[] coeffs, BigInteger x, BigInteger p) {
        BigInteger z = BigInteger.ZERO;
        for (int i = 0; i < coeffs.length; ++i) {
            z = z.multiply(x).add(coeffs[coeffs.length - i - 1]);
        }
        return z;
    }

    public static BigInteger hash(BigInteger ... x) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("no SHA-512 available");
        }
        for (BigInteger v : x) {
            md.update(v.toByteArray());
        }
        return new BigInteger(md.digest());
    }
}

