/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.construct.UInt64;
import org.gnunet.construct.VariableSizeArray;
import org.gnunet.secretsharing.Parameters;
import org.gnunet.voting.ChaumPedersenZkp;

public class DisjunctionZkp
implements Message {
    @UInt64
    public int numProofs;
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] challenge_c;
    @VariableSizeArray(lengthField="numProofs")
    public ChaumPedersenZkp[] chaumPedersenZkps;

    public boolean verifyChallenge() {
        BigInteger c_actual = new BigInteger(1, this.challenge_c);
        BigInteger c_expected = BigInteger.ZERO;
        for (ChaumPedersenZkp chaumPedersenZkp : this.chaumPedersenZkps) {
            BigInteger d = new BigInteger(1, chaumPedersenZkp.challenge_d);
            c_expected = c_expected.add(d).mod(Parameters.elgamalQ);
        }
        return c_actual.equals(c_expected) && this.computeChallengeFromCommits().equals(c_actual);
    }

    public BigInteger computeChallengeFromCommits() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm 'SHA-512' required but not provided");
        }
        for (ChaumPedersenZkp chaumPedersenZkp : this.chaumPedersenZkps) {
            digest.update(chaumPedersenZkp.commit_a);
            digest.update(chaumPedersenZkp.commit_b);
        }
        return new BigInteger(digest.digest()).mod(Parameters.elgamalQ);
    }
}

