/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Receive side of stub for testing ATSC components */

#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <GrTCPSink.h>
#include <GrAtscDerandomizer.h>
#include <GrAtscRSDecoder.h>
#include <GrAtscDeinterleaver.h>
#include <GrAtscViterbiDecoder.h>
#include <GrAtscDataSegToSoftDataSeg.h>
#include <atsc_types.h>
#include <unistd.h>

const int Rate	= 8000;

//typedef atsc_mpeg_packet_rs_encoded	input_type;
//typedef atsc_mpeg_packet_no_sync	input_type;
typedef atsc_data_segment		input_type;

void
usage (const char *name)
{
  cerr << "usage: " << name << " [-f <filename>] [-o <outfile>] [-p <port_number>]\n";
  exit (1);
}

int 
main (int argc, char **argv)
{
  char *filename = "mpeg.in";
  char *outfile = "atscblah.out";
  int	port = 0;
  GrTCPSink<atsc_mpeg_packet>   *tcpsink = 0;
  VrFileSink<atsc_mpeg_packet>  *filesink = 0;
  VrSink<atsc_mpeg_packet>	*finalsink;
  bool				logging = false;

  try {
    
    int	ch;
    while ((ch = getopt (argc, argv, "f:o:p:l")) != EOF){
      switch (ch){
      case 'f':
	filename = optarg;
	break;
    
      case 'o':
	outfile = optarg;
	break;

      case 'p':
	port = strtol (optarg, 0, 0);
	break;

      case 'l':
	logging = true;
	break;
	
      default:
	usage (argv[0]);
      }
    }

    // create the modules

    VrFileSource<input_type>* source =
      new VrFileSource<input_type>(Rate, filename, 0);

    // debug glue to match output of txstub
    GrAtscDataSegToSoftDataSeg *format_converter = new GrAtscDataSegToSoftDataSeg ();

    GrAtscViterbiDecoder *viterbi_decoder = new GrAtscViterbiDecoder();
    GrAtscDeinterleaver *deinterleaver = new GrAtscDeinterleaver();
    GrAtscRSDecoder *rs_decoder = new GrAtscRSDecoder();
    GrAtscDerandomizer *derandomizer = new GrAtscDerandomizer();

    VrFileSink<atsc_soft_data_segment>		*format_converter_log = 0;
    VrFileSink<atsc_mpeg_packet_rs_encoded>	*viterbi_decoder_log  = 0;
    VrFileSink<atsc_mpeg_packet_rs_encoded>	*deinterleaver_log = 0;
    VrFileSink<atsc_mpeg_packet_no_sync>	*rs_decoder_log = 0;
    VrFileSink<atsc_mpeg_packet>		*derandomizer_log = 0;

    if (port) {
      tcpsink = new GrTCPSink<atsc_mpeg_packet>(port);
      finalsink = tcpsink;
    } else {
      filesink = new VrFileSink<atsc_mpeg_packet>(outfile);
      finalsink = filesink;
    }
  
    VrMultiTask *m = new VrMultiTask ();
    m->add (finalsink);

    /* Hook up the connections among the modules now.  */

    // NWO_CONNECT (source, sink);

    NWO_CONNECT (source, format_converter);
    NWO_CONNECT (format_converter, viterbi_decoder);
    NWO_CONNECT (viterbi_decoder, deinterleaver);
    NWO_CONNECT (deinterleaver, rs_decoder);
    NWO_CONNECT (rs_decoder, derandomizer);
    NWO_CONNECT (derandomizer, finalsink);

    if (logging){
      format_converter_log = new VrFileSink<atsc_soft_data_segment>("01_format_converter.rxout");
      viterbi_decoder_log = new VrFileSink<atsc_mpeg_packet_rs_encoded>("02_viterbi_decoder.rxout");
      deinterleaver_log = new VrFileSink<atsc_mpeg_packet_rs_encoded>("03_deinterleaver.rxout");
      rs_decoder_log = new VrFileSink<atsc_mpeg_packet_no_sync>("04_rs_decoder.rxout");
      derandomizer_log = new VrFileSink<atsc_mpeg_packet>("05_derandomizer.rxout");

      m->add (format_converter_log);
      m->add (viterbi_decoder_log);
      m->add (deinterleaver_log);
      m->add (rs_decoder_log);
      m->add (derandomizer_log);

      NWO_CONNECT (format_converter, format_converter_log);
      NWO_CONNECT (viterbi_decoder, viterbi_decoder_log);
      NWO_CONNECT (deinterleaver, deinterleaver_log);
      NWO_CONNECT (rs_decoder, rs_decoder_log);
      NWO_CONNECT (derandomizer, derandomizer_log);
    }

    m->start ();
    while (1){
      m->process ();
    }
    m->stop ();

  } // end try

  catch (std::exception &e){
    cerr << "std library exception: " << e.what () << endl;
    exit (1);
  }
  catch (...) {
    cerr << "unknown exception thrown" << endl;
    exit (1);
  }

  return 0;
}

