#!/usr/bin/env python

#
# read mpeg transport stream from stdin,
# write transport error flag to stdout, one per line
#

import sys

while 1:
    pkt = sys.stdin.read (188)
    if not pkt or len(pkt) != 188:
        break

    if (ord(pkt[0]) != 0x47):
        sys.stdout.write ("missing 0x47\n")

    bit = (ord(pkt[1]) >> 7) & 0x1;
    sys.stdout.write ("%d\n" % bit)
    
