/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRARBFUNC_H_
#define _GRARBFUNC_H_

#include <VrSigProc.h>

/*!
 * \brief Arbitrary Function Block
 * 
 * Pass this block a pointer to a function.  The function
 * should return type oType, and take a single argument of
 * type "const iType &"
 * For example, to make a bock which returns the angle of a
 * VrComplex input, invoke:
 * GrArbFunc<VrComplex,float>(&arg)
 */


template<class iType, class oType>
class GrArbFunc : public VrSigProc {
public:
  GrArbFunc (oType (*f)(const iType&) ) : 
    VrSigProc (1, sizeof (iType), sizeof (oType)),
    func(f) {}

  virtual const char *name() { return "GrArbFunc"; }

  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

protected:
  oType (*func)(const iType&);
};

template<class iType, class oType> int
GrArbFunc<iType,oType>::work(VrSampleRange output, void *ao[],
			       VrSampleRange inputs[], void *ai[])
{
  iType **i = ((iType **)ai);
  oType **o = ((oType **)ao);
  unsigned int size = output.size;
 
  for (unsigned int x = 0; x < size; x++)
    o[0][x] = (*func)(reinterpret_cast<const iType &>(i[0][x]));
  //    o[0][x] = (*func)(reinterpret_cast<const iType&>(&i[0][x]));

  return output.size;
}


#endif /* _GRMAGNITUDE_H_ */
