/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_GrFIRfilterXXX.py
 * Any changes made to this file will be overwritten.
 */

#include <@NAME@.h>
#include <@FIR_TYPE@.h>
#include <gr_fir_util.h>

@NAME@::@NAME@ (int decimation_factor,
	    const std::vector<@TAP_TYPE@> &taps)
  : VrDecimatingSigProc<@I_TYPE@, @O_TYPE@>(1, decimation_factor),
    d_builder (0), d_updated (0)
{
  d_fir = gr_fir_util::create_@FIR_TYPE@ (taps);
}

@NAME@::@NAME@ (int decimation_factor, @FIR_BUILDER@ *builder)
  : VrDecimatingSigProc<@I_TYPE@,@O_TYPE@>(1, decimation_factor),
    d_builder (builder), d_updated (0)
{
  std::vector<@TAP_TYPE@>	dummy_taps;
  d_fir = gr_fir_util::create_@FIR_TYPE@ (dummy_taps);
}

@NAME@::~@NAME@ ()
{
  delete d_fir;
  delete d_builder;
}

void
@NAME@::initialize ()
{
  if (d_builder)
    d_fir->set_taps (d_builder->taps (getInputSamplingFrequencyN (0)));

  history = d_fir->ntaps ();
}

void
@NAME@::setTaps (const std::vector<@TAP_TYPE@> &taps)
{
  delete d_builder;		// if you're setting taps, you're not using the builder
  d_builder = 0;
  d_new_taps = taps;
  d_updated = 1;
}

int
@NAME@::work (VrSampleRange output, void *ao[],
	      VrSampleRange inputs[], void *ai[])
{
  @I_TYPE@ *in = (@I_TYPE@ *) ai[0];
  @O_TYPE@ *out = (@O_TYPE@ *) ao[0];

  if (d_updated) {
    d_fir->set_taps (d_new_taps);
    initialize ();
    d_updated = 0;
  }

  if (decimation == 1)
    d_fir->filterN (out, in, output.size);

  else
    d_fir->filterNdec (out, in, output.size, decimation);

  return output.size;
}
