/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_gr_fir_util.py.
 *
 * Any changes made to this file will be overwritten.
 */

#ifndef _GR_FIR_UTIL_H_
#define _GR_FIR_UTIL_H_

/*!
 * \brief routines to create gr_fir_XXX's
 *
 * This class handles selecting the fastest version of the finite
 * implulse response filter available for your platform.  This
 * interface should be used by the rest of the system for creating
 * gr_fir_XXX's.
 *
 * The trailing suffix has the form _IOT where I codes the input type,
 * O codes the output type, and T codes the tap type.
 * I,O,T are elements of the set 'S' (short), 'F' (float), 'C' (VrComplex), 
 * 'I' (short)
 */

#include <VrComplex.h>
#include <vector>

class gr_fir_CCF;
class gr_fir_FCC;
class gr_fir_CCC;
class gr_fir_FFF;
class gr_fir_SCC;
class gr_fir_SIS;
class gr_fir_FSF;

// structures returned by get_gr_fir_XXX_info methods


struct gr_fir_CCF_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_CCF	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_FCC_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_FCC	*(*create)(const std::vector<VrComplex> &taps);
};

struct gr_fir_CCC_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_CCC	*(*create)(const std::vector<VrComplex> &taps);
};

struct gr_fir_FFF_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_FFF	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_SCC_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_SCC	*(*create)(const std::vector<VrComplex> &taps);
};

struct gr_fir_SIS_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_SIS	*(*create)(const std::vector<short> &taps);
};

struct gr_fir_FSF_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_FSF	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_util {

  // create a fast version of gr_fir_XXX.

  static gr_fir_CCF *create_gr_fir_CCF (const std::vector<float> &taps);
  static gr_fir_FCC *create_gr_fir_FCC (const std::vector<VrComplex> &taps);
  static gr_fir_CCC *create_gr_fir_CCC (const std::vector<VrComplex> &taps);
  static gr_fir_FFF *create_gr_fir_FFF (const std::vector<float> &taps);
  static gr_fir_SCC *create_gr_fir_SCC (const std::vector<VrComplex> &taps);
  static gr_fir_SIS *create_gr_fir_SIS (const std::vector<short> &taps);
  static gr_fir_FSF *create_gr_fir_FSF (const std::vector<float> &taps);

  // Get information about all gr_fir_XXX implementations.
  // This is useful for benchmarking, testing, etc without having to
  // know a priori what's linked into this image
  //
  // The caller must pass in a valid pointer to a vector.
  // The vector will be filled with structs describing the
  // available implementations.

  static void get_gr_fir_CCF_info (std::vector<gr_fir_CCF_info> *info);
  static void get_gr_fir_FCC_info (std::vector<gr_fir_FCC_info> *info);
  static void get_gr_fir_CCC_info (std::vector<gr_fir_CCC_info> *info);
  static void get_gr_fir_FFF_info (std::vector<gr_fir_FFF_info> *info);
  static void get_gr_fir_SCC_info (std::vector<gr_fir_SCC_info> *info);
  static void get_gr_fir_SIS_info (std::vector<gr_fir_SIS_info> *info);
  static void get_gr_fir_FSF_info (std::vector<gr_fir_FSF_info> *info);

};

#endif /* _GR_FIR_UTIL_H_ */
