/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GR_NCO_H_
#define _GR_NCO_H_


#include <VrComplex.h>
#include <vector>
// #include <gr_sincos.h>
#include <cmath>

using std::vector;

/*!
 * \brief base class template for Numerically Controlled Oscillator (NCO)
 */


//FIXME  Eventually generalize this to fixed point

template<class o_type, class i_type> 
class gr_nco {
public:
  gr_nco () : phase (0), phase_inc(0) {}

  virtual ~gr_nco () {}

  // radians
  void set_phase (float angle) {
    phase = angle;
  }

  void adjust_phase (float delta_phase) {
    phase += delta_phase;
  }


  // angle_rate is in radians / step
  void set_freq (float angle_rate){
    phase_inc = angle_rate;
  }

  // angle_rate is a delta in radians / step
  void adjust_freq (float delta_angle_rate)
  {
    phase_inc += delta_angle_rate;
  }

  // increment current phase angle

  void step () 
  { 
    phase += phase_inc; 
    if (fabs (phase) > M_PI){
      
      while (phase > M_PI)
	phase -= 2*M_PI;

      while (phase < -M_PI)
	phase += 2*M_PI;
    }
  }

  void step (int n) { phase += phase_inc * n; }

  // units are radians / step
  float get_phase () const { return phase; }
  float get_freq () const { return phase_inc; }

  // compute cos and sin for current phase angle
  void cossin (float &i, float &q) const;

  // compute cos or sin for current phase angle
  float cos () const { return std::cos (phase); }
  float sin () const { return std::sin (phase); }

protected:
  float phase;
  float phase_inc;
};

/*
 * FIXME: since this is a template, we can't include <config.h>.
 * This appears to preclude conditionalizing the availability of 
 * __sincosf.  If you know better, please fix this code.
 * Actually, I guess we could create out own function and have
 * it do the include (later...)
 */

template<class o_type, class i_type> 
void
gr_nco<o_type,i_type>::cossin (float &i, float &q) const
{
#if 0
  __sincosf (phase, &q, &i);
#else
  i = std::cos (phase);
  q = std::sin (phase);
#endif
}

#endif /* _NCO_H_ */
