/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRSIMPLESCOPESINK_H_
#define _GRSIMPLESCOPESINK_H_

#include <VrSink.h>
#include "VrGUI.h"


extern "C" {
#include <dlfcn.h>
#include <float.h>
#include <math.h>
	   }

#define XAXIS_NAME			"Time"
#define YAXIS_NAME			"Amplitude"


template<class iType> 
class GrSimpleScopeSink : public VrSink<iType> {

 public:
  virtual const char *name() { return "GrSimpleScopeSink"; }

  virtual int work3(VrSampleRange output, 
		    VrSampleRange inputs[], void *i[]);

  void clear() { plot->clear(); }
  void set_persistent(int arg_persistent) {plot->set_persistent(arg_persistent); }

  GrSimpleScopeSink(VrGUILayout *layout, double arg_ymin, double arg_ymax,
		    int arg_nPoints = maxnPoints);
  ~GrSimpleScopeSink();


  static const int maxnPoints = 1000;	// number of points to plot
  static const int divisions = 10;	// number of x-axis divisions

 private:
  double   	*xValues;
  double   	*yValues;		// amplitudes to plot on y-axis
  int       	nPoints;		// number of points to plot
  int		ncollected;		// current number of points collected

  VrGUIPlot	*plot;
  double	ymin, ymax;		// possible range of sample values
};

/*****************************************************************************
 * Implementation of template (C++ requires it to be in .h file).
 ****************************************************************************/


/*
 * Creates a new GrSimpleScopeSink.
 */
template<class iType>
GrSimpleScopeSink<iType>::GrSimpleScopeSink(VrGUILayout *layout, 
	double arg_ymin, double arg_ymax, int arg_nPoints)
{
  nPoints = arg_nPoints;
  if (nPoints > maxnPoints)
    nPoints = maxnPoints;

  ncollected = 0;

  yValues = new double[nPoints];
  xValues = new double[nPoints];

  for (int i = 0; i < nPoints; i++)
    xValues[i] = i;

  ymin = arg_ymin;
  ymax = arg_ymax;

  // FIXME remove casts on ymin, ymax...
  plot = new VrGUIPlot (layout, XAXIS_NAME, YAXIS_NAME, 1,
			0, nPoints, (int) ymin, (int) ymax, nPoints, divisions);

  // setOptimalSize(nPoints);
}

template<class iType> int
GrSimpleScopeSink<iType>::work3(VrSampleRange output, 
				VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  sync(output.index);

  unsigned int	n;
  bool already_output_something_p = false;

  for (n = 0; n < output.size; n++){
    yValues[ncollected++] = *i[0]++;
    if (ncollected == nPoints){
      if (!already_output_something_p){
	plot->data (xValues, yValues, nPoints);
	already_output_something_p = true;
      }
      ncollected = 0;
    }
  }

  return output.size;
}

template<class iType> 
GrSimpleScopeSink<iType>::~GrSimpleScopeSink()
{
  delete[] xValues;
  delete[] yValues;
  // delete plot
}

#endif



