/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrSink.h>

class usrp_tx;

/*!
 * \brief Sink that writes to USRP A/D's via the FPGA
 */
class GrUsrpSink : public GrSink
{
 private:
  int	 	d_ninputs;
  usrp_tx	*d_usrp;

 public:
  GrUsrpSink (int which_board,
	      unsigned int usrp_tx_config,
	      unsigned int interp_rate);
  ~GrUsrpSink ();

  /*!
   * inovkes constructor and returns instance or 0 if trouble
   */
  static GrUsrpSink *make (int which_board,
			   unsigned int usrp_tx_config,
			   unsigned interp_rate);
  
  virtual const char *name () { return "GrUsrpSink"; }

  virtual int work3 (VrSampleRange output,
		     VrSampleRange inputs[], void *i[]);

  void initialize ();

  bool set_interp_rate (unsigned int rate);
  bool set_tx_freq (int channel, double freq);
  bool set_ext_clk_div (unsigned int div);

  bool _set_interp_reg (unsigned int regval);	// diagnostics only

  // ACCESSORS

  double  get_oscillator_freq () const; 	// freq of master oscillator on board
  unsigned int get_interp_rate () const;
  double get_tx_freq (int channel) const;
  unsigned int get_ext_clk_div () const;
};
